/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared;

import dk.cloudcreate.essentials.shared.FailFast;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.stream.Collectors;

public final class MessageFormatter {
    public static String msg(String message, Object ... messageAnchorPlaceHolderValues) {
        FailFast.requireNonNull(message, "You must supply a message");
        FailFast.requireNonNull(messageAnchorPlaceHolderValues, "You must supply a messageAnchorPlaceHolderValues");
        return String.format(message.replaceAll("\\{}", "%s"), messageAnchorPlaceHolderValues);
    }

    public static String bind(String message, Map<String, Object> bindings) {
        FailFast.requireNonNull(message, "You must supply a message");
        FailFast.requireNonNull(bindings, "You must supply bindings");
        return MessageFormatter.bind(message, bindings.entrySet().stream().map(nameValue -> new NamedArgumentBinding((String)nameValue.getKey(), nameValue.getValue())).collect(Collectors.toList()));
    }

    public static String bind(String message, NamedArgumentBinding ... bindings) {
        FailFast.requireNonNull(message, "You must supply a message");
        FailFast.requireNonNull(bindings, "You must supply bindings");
        return MessageFormatter.bind(message, Arrays.asList(bindings));
    }

    public static String bind(String message, List<NamedArgumentBinding> bindings) {
        FailFast.requireNonNull(message, "You must supply a message");
        FailFast.requireNonNull(bindings, "You must supply bindings");
        String result = message;
        for (NamedArgumentBinding bind : bindings) {
            try {
                result = result.replaceAll("\\{:" + bind.name + "}", bind.value.toString());
            }
            catch (MissingFormatArgumentException e) {
                throw new IllegalArgumentException(MessageFormatter.msg("Failed to replace bind :{} with value '{}'", bind.name, bind.value, bind.value), e);
            }
        }
        return result;
    }

    public static class NamedArgumentBinding {
        public final String name;
        public final Object value;

        public NamedArgumentBinding(String name, Object value) {
            this.name = FailFast.requireNonNull(name, "You must supply a name");
            this.value = value;
        }

        public static NamedArgumentBinding arg(String name, Object value) {
            return new NamedArgumentBinding(name, value);
        }

        public String toString() {
            return ":" + this.name + " -> " + this.value;
        }
    }
}

