/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.MessageFormatter;
import dk.cloudcreate.essentials.shared.reflection.Classes;
import dk.cloudcreate.essentials.shared.reflection.Constructors;
import dk.cloudcreate.essentials.shared.reflection.Fields;
import dk.cloudcreate.essentials.shared.reflection.GetFieldException;
import dk.cloudcreate.essentials.shared.reflection.MethodInvocationFailedException;
import dk.cloudcreate.essentials.shared.reflection.Methods;
import dk.cloudcreate.essentials.shared.reflection.NoFieldFoundException;
import dk.cloudcreate.essentials.shared.reflection.NoMatchingMethodFoundException;
import dk.cloudcreate.essentials.shared.reflection.Parameters;
import dk.cloudcreate.essentials.shared.reflection.ReflectionException;
import dk.cloudcreate.essentials.shared.reflection.SetFieldException;
import dk.cloudcreate.essentials.shared.reflection.TooManyMatchingFieldsFoundException;
import dk.cloudcreate.essentials.shared.reflection.TooManyMatchingMethodsFoundException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class Reflector {
    private static final ConcurrentMap<Class<?>, Reflector> REFLECTOR_CACHE = new ConcurrentHashMap();
    public final Class<?> type;
    public final List<Constructor<?>> constructors;
    public final Set<Method> methods;
    public final Set<Field> fields;

    public static Reflector reflectOn(String fullyQualifiedClassName) {
        FailFast.requireNonNull(fullyQualifiedClassName, "You must supply a fullyQualifiedClassName");
        return Reflector.reflectOn(Classes.forName(fullyQualifiedClassName));
    }

    public static Reflector reflectOn(Class<?> type) {
        FailFast.requireNonNull(type, "You must supply a type");
        return REFLECTOR_CACHE.computeIfAbsent(type, _type -> new Reflector((Class<?>)_type));
    }

    private Reflector(Class<?> type) {
        this.type = type;
        this.constructors = Constructors.constructors(type);
        this.methods = Methods.methods(type);
        this.fields = Fields.fields(type);
    }

    public boolean hasDefaultConstructor() {
        return this.getDefaultConstructor().isPresent();
    }

    public Optional<Constructor<?>> getDefaultConstructor() {
        return this.constructors.stream().filter(_constructor -> _constructor.getParameterCount() == 0).findFirst();
    }

    public boolean hasMatchingConstructorBasedOnArguments(Object ... constructorArguments) {
        Class[] actualArgumentTypes = Parameters.argumentTypes(constructorArguments);
        return this.constructors.stream().filter(_constructor -> Parameters.parameterTypesMatches(actualArgumentTypes, _constructor.getParameterTypes(), false)).count() == 1L;
    }

    public boolean hasMatchingConstructorBasedOnParameterTypes(Class<?> ... parameterTypes) {
        return this.constructors.stream().filter(_constructor -> Parameters.parameterTypesMatches(parameterTypes, _constructor.getParameterTypes(), true)).count() == 1L;
    }

    public <T> T newInstance(Object ... constructorArguments) {
        Class[] actualArgumentTypes = Parameters.argumentTypes(constructorArguments);
        Constructor constructor = this.constructors.stream().filter(_constructor -> Parameters.parameterTypesMatches(actualArgumentTypes, _constructor.getParameterTypes(), false)).findFirst().orElseThrow(() -> new ReflectionException(MessageFormatter.msg("Couldn't find a single constructor that matched {}", Arrays.toString(actualArgumentTypes))));
        try {
            return constructor.newInstance(constructorArguments);
        }
        catch (Exception e) {
            throw new ReflectionException(MessageFormatter.msg("Failed to create a new instance of constructor {} using arguments of type {}", constructor, actualArgumentTypes), e);
        }
    }

    public Class<?> type() {
        return this.type;
    }

    public boolean hasMethod(String methodName, boolean staticMethod, Class<?> ... argumentTypes) {
        return this.findMatchingMethod(methodName, staticMethod, argumentTypes).isPresent();
    }

    public Optional<Method> findMatchingMethod(String methodName, boolean staticMethod, Class<?> ... argumentTypes) {
        FailFast.requireNonNull(methodName, "You must supply a methodName");
        List matchingMethods = this.methods.stream().filter(method -> method.getName().equals(methodName) && staticMethod == Modifier.isStatic(method.getModifiers()) && Parameters.parameterTypesMatches(argumentTypes, method.getParameterTypes(), false)).collect(Collectors.toList());
        if (matchingMethods.isEmpty()) {
            return Optional.empty();
        }
        if (matchingMethods.size() == 1) {
            return Optional.of((Method)matchingMethods.get(0));
        }
        throw new TooManyMatchingMethodsFoundException(MessageFormatter.msg("Found {} {} methods within {} matching on name '{}' and argument-types {}", matchingMethods.size(), staticMethod ? "static" : "instance", this.type.getName(), Arrays.toString(argumentTypes)));
    }

    public <R> R invokeStatic(String methodName, Object ... arguments) {
        FailFast.requireNonNull(methodName, "You must supply a methodName");
        Class[] argumentTypes = Parameters.argumentTypes(arguments);
        Method method = this.findMatchingMethod(methodName, true, argumentTypes).orElseThrow(() -> new NoMatchingMethodFoundException(MessageFormatter.msg("Failed to find static method '{}' on type '{}' taking arguments of {}", methodName, this.type.getName(), Arrays.toString(argumentTypes))));
        return this.invokeStatic(method, arguments);
    }

    public <R> R invokeStatic(Method method, Object ... arguments) {
        FailFast.requireNonNull(method, "You must supply a method");
        try {
            return (R)method.invoke(this.type, arguments);
        }
        catch (Exception e) {
            throw new MethodInvocationFailedException(MessageFormatter.msg("Failed to invoke static method '{}' on type '{}' taking arguments of {}", method.getName(), this.type.getName(), Arrays.toString(method.getParameterTypes())), e);
        }
    }

    public <R> R invoke(String methodName, Object invokeOnObject, Object ... withArguments) {
        FailFast.requireNonNull(methodName, "You must supply a methodName");
        FailFast.requireNonNull(invokeOnObject, "You must supply an invokeOnObject");
        Class[] argumentTypes = Parameters.argumentTypes(withArguments);
        Method method = this.findMatchingMethod(methodName, false, argumentTypes).orElseThrow(() -> new NoMatchingMethodFoundException(MessageFormatter.msg("Failed to find method '{}' on type '{}' taking arguments of {}", methodName, this.type.getName(), Arrays.toString(argumentTypes))));
        return this.invoke(method, invokeOnObject, withArguments);
    }

    public <R> R invoke(Method method, Object invokeOnObject, Object ... withArguments) {
        FailFast.requireNonNull(method, "You must supply a method");
        FailFast.requireNonNull(invokeOnObject, "You must supply an invokeOnObject");
        try {
            return (R)method.invoke(invokeOnObject, withArguments);
        }
        catch (Exception e) {
            throw new ReflectionException(MessageFormatter.msg("Failed to invoke method '{}' on '{}'", method.toGenericString(), invokeOnObject), e);
        }
    }

    public Optional<Field> findFieldByName(String fieldName) {
        return this.fields.stream().filter(_field -> _field.getName().equals(fieldName)).findFirst();
    }

    public Optional<Field> findStaticFieldByName(String fieldName) {
        return this.fields.stream().filter(_field -> _field.getName().equals(fieldName) && Modifier.isStatic(_field.getModifiers())).findFirst();
    }

    public <R> R get(Object object, String fieldName) {
        FailFast.requireNonNull(object, "You must supply an object");
        FailFast.requireNonNull(fieldName, "You must supply a fieldName");
        return this.get(object, this.findFieldByName(fieldName).orElseThrow(() -> new NoFieldFoundException(MessageFormatter.msg("Failed to find field '{}' in type '{}'", fieldName, this.type.getName()))));
    }

    public <R> R get(Object object, Field field) {
        FailFast.requireNonNull(object, "You must supply an object");
        FailFast.requireNonNull(field, "You must supply a field");
        try {
            return (R)field.get(object);
        }
        catch (Exception e) {
            throw new GetFieldException(MessageFormatter.msg("Failed to get field {}#{} inside object of type '{}'", this.type.getName(), field.getName(), object.getClass().getName()));
        }
    }

    public <R> R getStatic(String fieldName) {
        FailFast.requireNonNull(fieldName, "You must supply a fieldName");
        return this.getStatic(this.findStaticFieldByName(fieldName).orElseThrow(() -> new NoFieldFoundException(MessageFormatter.msg("Failed to find static field '{}' in type '{}'", fieldName, this.type.getName()))));
    }

    public <R> R getStatic(Field field) {
        FailFast.requireNonNull(field, "You must supply a field");
        try {
            return (R)field.get(null);
        }
        catch (Exception e) {
            throw new GetFieldException(MessageFormatter.msg("Failed to get static field {}#{}", this.type.getName(), field.getName()));
        }
    }

    public void set(Object object, String fieldName, Object newFieldValue) {
        FailFast.requireNonNull(object, "You must supply an object");
        FailFast.requireNonNull(fieldName, "You must supply a fieldName");
        this.set(object, this.findFieldByName(fieldName).orElseThrow(() -> new NoFieldFoundException(MessageFormatter.msg("Failed to find field '{}' in type '{}'", fieldName, this.type.getName()))), newFieldValue);
    }

    public void set(Object object, Field field, Object newFieldValue) {
        FailFast.requireNonNull(object, "You must supply an object");
        FailFast.requireNonNull(field, "You must supply a field");
        try {
            field.set(object, newFieldValue);
        }
        catch (Exception e) {
            throw new SetFieldException(MessageFormatter.msg("Failed to set field {}#{} inside object of type '{}'", this.type.getName(), field.getName(), object.getClass().getName()));
        }
    }

    public void setStatic(String fieldName, Object newFieldValue) {
        FailFast.requireNonNull(fieldName, "You must supply a fieldName");
        this.setStatic(this.findStaticFieldByName(fieldName).orElseThrow(() -> new NoFieldFoundException(MessageFormatter.msg("Failed to find static field '{}' in type '{}'", fieldName, this.type.getName()))), newFieldValue);
    }

    public void setStatic(Field field, Object newFieldValue) {
        FailFast.requireNonNull(field, "You must supply a field");
        try {
            field.set(null, newFieldValue);
        }
        catch (Exception e) {
            throw new SetFieldException(MessageFormatter.msg("Failed to set static field {}#{}", this.type.getName(), field.getName()));
        }
    }

    public Optional<Field> findFieldByAnnotation(Class<? extends Annotation> annotation) {
        FailFast.requireNonNull(annotation, "You must supply an annotation");
        List matchingFields = this.fields.stream().filter(field -> field.isAnnotationPresent(annotation)).collect(Collectors.toList());
        if (matchingFields.isEmpty()) {
            return Optional.empty();
        }
        if (matchingFields.size() == 1) {
            return Optional.of((Field)matchingFields.get(0));
        }
        throw new TooManyMatchingFieldsFoundException(MessageFormatter.msg("Found {} fields within {} matching on annotation {}", matchingFields.size(), this.type.getName(), annotation.getName()));
    }
}

