/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional.tuple;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.tuple.Tuple;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Pair<T1, T2>
implements Tuple<Pair<T1, T2>> {
    public final T1 _1;
    public final T2 _2;

    public Pair(T1 t1, T2 t2) {
        this._1 = t1;
        this._2 = t2;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 t1, T2 t2) {
        return new Pair<T1, T2>(t1, t2);
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public List<?> toList() {
        return List.of(this._1, this._2);
    }

    public T1 _1() {
        return this._1;
    }

    public T2 _2() {
        return this._2;
    }

    public Pair<T2, T1> swap() {
        return Tuple.of(this._2, this._1);
    }

    public Map.Entry<T1, T2> toEntry() {
        return new AbstractMap.SimpleEntry<T1, T2>(this._1, this._2);
    }

    public <R1, R2> Pair<R1, R2> map(BiFunction<? super T1, ? super T2, Pair<R1, R2>> mappingFunction) {
        FailFast.requireNonNull(mappingFunction, "You must supply a mapping function");
        return mappingFunction.apply(this._1, this._2);
    }

    public <R1, R2> Pair<R1, R2> map(Function<? super T1, ? super R1> mappingFunction1, Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        R1 r1 = mappingFunction1.apply(this._1);
        R2 r2 = mappingFunction2.apply(this._2);
        return Tuple.of(r1, r2);
    }

    public <R1> Pair<R1, T2> map1(Function<? super T1, ? super R1> mappingFunction1) {
        FailFast.requireNonNull(mappingFunction1, "You must supply a mappingFunction1");
        R1 r1 = mappingFunction1.apply(this._1);
        return Tuple.of(r1, this._2);
    }

    public <R2> Pair<T1, R2> map2(Function<? super T2, ? super R2> mappingFunction2) {
        FailFast.requireNonNull(mappingFunction2, "You must supply a mappingFunction2");
        R2 r2 = mappingFunction2.apply(this._2);
        return Tuple.of(this._1, r2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)o;
        return Objects.equals(this._1, pair._1) && Objects.equals(this._2, pair._2);
    }

    public int hashCode() {
        return Objects.hash(this._1, this._2);
    }

    public String toString() {
        return "(" + this._1 + ", " + this._2 + ")";
    }
}

