/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.time;

import dk.cloudcreate.essentials.shared.FailFast;
import java.time.Duration;

public class Timing {
    public final String description;
    public final Duration duration;

    public static Timing of(String description, Duration duration) {
        return new Timing(description, duration);
    }

    public static Timing of(Duration duration) {
        return new Timing(duration);
    }

    public Timing(String description, Duration duration) {
        this.description = description;
        this.duration = FailFast.requireNonNull(duration, "duration is null");
    }

    public Timing(Duration duration) {
        this.duration = FailFast.requireNonNull(duration, "duration is null");
        this.description = null;
    }

    public String getDescription() {
        return this.description;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        return "Timing {duration=" + (this.duration.toMillis() < 10000L ? this.duration.toMillis() + " ms" : this.duration.toSeconds() + " s") + (String)(this.description != null ? ", description='" + this.description + "'" : "") + "}";
    }
}

