/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import java.util.function.BiFunction;

@FunctionalInterface
public interface CheckedBiFunction<T1, T2, R> {
    public static <T1, T2, R> BiFunction<T1, T2, R> safe(CheckedBiFunction<T1, T2, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedBiFunction instance provided");
        return (t1, t2) -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t1, t2);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> safe(String contextMessage, CheckedBiFunction<T1, T2, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedBiFunction instance provided");
        return (t1, t2) -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t1, t2);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public R apply(T1 var1, T2 var2) throws Exception;
}

