/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import java.util.function.Function;

@FunctionalInterface
public interface CheckedFunction<T, R> {
    public static <T, R> Function<T, R> safe(CheckedFunction<T, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedFunction instance provided");
        return t -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static <T, R> Function<T, R> safe(String contextMessage, CheckedFunction<T, R> functionThatCanFailWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(functionThatCanFailWithACheckedException, "No CheckedFunction instance provided");
        return t -> {
            try {
                return functionThatCanFailWithACheckedException.apply(t);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public R apply(T var1) throws Exception;
}

