/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.reflection;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.reflection.Accessibles;
import dk.cloudcreate.essentials.shared.reflection.Classes;
import dk.cloudcreate.essentials.shared.reflection.Interfaces;
import dk.cloudcreate.essentials.shared.reflection.Parameters;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class Methods {
    public static Optional<Method> findMatchingMethod(Set<Method> methods, String methodName, Class<?> returnType, Class<?> ... parametersTypes) {
        FailFast.requireNonNull(methods, "You must supply a set of Methods");
        FailFast.requireNonBlank(methodName, "You must supply a methodName");
        FailFast.requireNonNull(returnType, "You must supply a returnType");
        FailFast.requireNonNull(parametersTypes, "You must supply parametersTypes");
        return methods.stream().filter(method -> method.getName().equals(methodName)).filter(method -> method.getReturnType().equals(returnType)).filter(method -> Parameters.parameterTypesMatches(method.getParameterTypes(), parametersTypes, true)).findFirst();
    }

    public static Set<Method> methods(Class<?> type) {
        FailFast.requireNonNull(type, "You must supply a type");
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> currentType = type; currentType != null; currentType = currentType.getSuperclass()) {
            for (Method declaredMethod : currentType.getDeclaredMethods()) {
                if (currentType.getPackageName().startsWith("java.") && !Modifier.isPublic(declaredMethod.getModifiers())) continue;
                boolean hasAlreadyBeenOverriddenByASubClass = false;
                for (Method alreadyDiscoveredMethod : methods) {
                    if (!alreadyDiscoveredMethod.getName().equals(declaredMethod.getName()) || !Parameters.parameterTypesMatches(declaredMethod.getParameterTypes(), alreadyDiscoveredMethod.getParameterTypes(), true)) continue;
                    int specificity = Classes.compareTypeSpecificity(declaredMethod.getReturnType(), alreadyDiscoveredMethod.getReturnType());
                    if (specificity <= 0) {
                        hasAlreadyBeenOverriddenByASubClass = true;
                        break;
                    }
                    methods.remove(alreadyDiscoveredMethod);
                    break;
                }
                if (hasAlreadyBeenOverriddenByASubClass) continue;
                methods.add((Method)Accessibles.accessible(declaredMethod));
            }
        }
        for (Class clazz : Interfaces.interfaces(type)) {
            for (Method declaredMethod : clazz.getDeclaredMethods()) {
                if (clazz.getPackageName().startsWith("java.") && !Modifier.isPublic(declaredMethod.getModifiers())) continue;
                boolean hasAlreadyBeenOverriddenByASubClass = false;
                for (Method alreadyDiscoveredMethod : methods) {
                    if (!alreadyDiscoveredMethod.getName().equals(declaredMethod.getName()) || !Parameters.parameterTypesMatches(declaredMethod.getParameterTypes(), alreadyDiscoveredMethod.getParameterTypes(), true)) continue;
                    hasAlreadyBeenOverriddenByASubClass = true;
                    break;
                }
                if (hasAlreadyBeenOverriddenByASubClass) continue;
                methods.add(Accessibles.accessible(declaredMethod));
            }
        }
        return methods;
    }
}

