/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.logic;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.logic.IfPredicate;
import java.util.function.Supplier;

abstract class IfThenElseLogic<RETURN_TYPE> {
    private IfThenElseLogic<RETURN_TYPE> parent;
    private IfThenElseLogic<RETURN_TYPE> child;
    private IfPredicate ifPredicate;
    private Supplier<RETURN_TYPE> ifReturnValueSupplier;

    IfThenElseLogic(IfThenElseLogic<RETURN_TYPE> parent) {
        this.parent = FailFast.requireNonNull(parent, "You must provide a parent IfTheElseLogic instance");
        parent.child = this;
    }

    IfThenElseLogic(IfPredicate ifPredicate, Supplier<RETURN_TYPE> ifReturnValueSupplier) {
        this.ifPredicate = FailFast.requireNonNull(ifPredicate, "You must provide an If predicate lambda");
        this.ifReturnValueSupplier = FailFast.requireNonNull(ifReturnValueSupplier, "You must provide a return value supplier lambda");
    }

    void set(IfPredicate ifPredicate, Supplier<RETURN_TYPE> ifReturnValueSupplier) {
        this.ifPredicate = FailFast.requireNonNull(ifPredicate, "You must provide an If predicate lambda");
        this.ifReturnValueSupplier = FailFast.requireNonNull(ifReturnValueSupplier, "You must provide a return value supplier lambda");
    }

    IfThenElseLogic<RETURN_TYPE> getIfExpression() {
        IfThenElseLogic<RETURN_TYPE> currentIfTheElse = this;
        while (currentIfTheElse.parent != null) {
            currentIfTheElse = currentIfTheElse.parent;
        }
        return currentIfTheElse;
    }

    protected IfThenElseLogic<RETURN_TYPE> getChild() {
        return this.child;
    }

    protected boolean evaluate() {
        FailFast.requireNonNull(this.ifPredicate, this.getClass().getName() + " doesn't have an if predicate");
        return this.ifPredicate.test();
    }

    protected RETURN_TYPE resolveReturnValue() {
        return this.ifReturnValueSupplier.get();
    }
}

