/*
 * Decompiled with CFR 0.152.
 */
package dk.cloudcreate.essentials.shared.functional;

import dk.cloudcreate.essentials.shared.FailFast;
import dk.cloudcreate.essentials.shared.functional.CheckedExceptionRethrownException;
import java.util.function.Supplier;

@FunctionalInterface
public interface CheckedSupplier<R> {
    public static <R> Supplier<R> safe(CheckedSupplier<R> supplierThatCanFailedWithACheckedException) {
        FailFast.requireNonNull(supplierThatCanFailedWithACheckedException, "No CheckedSupplier instance provided");
        return () -> {
            try {
                return supplierThatCanFailedWithACheckedException.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(e.getMessage(), e);
            }
        };
    }

    public static <R> Supplier<R> safe(String contextMessage, CheckedSupplier<R> supplierThatCanFailedWithACheckedException) {
        FailFast.requireNonNull(contextMessage, "No contextMessage provided");
        FailFast.requireNonNull(supplierThatCanFailedWithACheckedException, "No CheckedSupplier instance provided");
        return () -> {
            try {
                return supplierThatCanFailedWithACheckedException.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CheckedExceptionRethrownException(contextMessage, e);
            }
        };
    }

    public R get() throws Exception;
}

