/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.catalog;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.query.FilterItem;
import dk.eobjects.metamodel.query.GroupByItem;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ColumnDictionary
implements IDictionary {
    private static final long serialVersionUID = 5860761529554184426L;
    private String _name;
    private DataContext _dataContext;
    private Column _column;

    public ColumnDictionary(String name, DataContext dataContext, Column column) {
        this._name = name;
        this._dataContext = dataContext;
        this._column = column;
    }

    public String getName() {
        return this._name;
    }

    public boolean[] isValid(String ... values) {
        SelectItem selectItem = new SelectItem(this._column);
        boolean[] result = new boolean[values.length];
        ArrayList<FilterItem> items = new ArrayList<FilterItem>();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (value == null) continue;
            if (value.indexOf(39) != -1) {
                String wildcardValue = value.replace('\'', '%');
                items.add(new FilterItem(selectItem, OperatorType.LIKE, (Object)wildcardValue));
                continue;
            }
            items.add(new FilterItem(selectItem, OperatorType.EQUALS_TO, (Object)value));
        }
        Query q = new Query().select(new SelectItem[]{selectItem}).selectCount().from(this._column.getTable()).where(new FilterItem[]{new FilterItem(items.toArray(new FilterItem[items.size()]))}).groupBy(new GroupByItem[]{new GroupByItem(selectItem)});
        List queryResult = this._dataContext.executeQuery(q).toObjectArrays();
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            boolean found = false;
            if (value != null) {
                Iterator it = queryResult.iterator();
                while (it.hasNext() && !found) {
                    Object[] objects = (Object[])it.next();
                    if (!value.equals(objects[0])) continue;
                    found = true;
                    if (((Number)objects[1]).intValue() > 0) {
                        result[i] = true;
                        continue;
                    }
                    result[i] = false;
                }
            }
            if (found) continue;
            result[i] = false;
        }
        return result;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

