/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.catalog;

import dk.eobjects.metamodel.util.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedRegex
implements Serializable {
    private static final long serialVersionUID = 6546221842231307672L;
    private String _name;
    private String _expression;

    public NamedRegex() {
    }

    public NamedRegex(String name, String expression) {
        this();
        this.setName(name);
        this.setExpression(expression);
    }

    public String getName() {
        return this._name;
    }

    public String getExpression() {
        return this._expression;
    }

    public NamedRegex setName(String name) {
        this._name = name;
        return this;
    }

    public NamedRegex setExpression(String expression) {
        this._expression = expression;
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this._name).append("expression", (Object)this._expression).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedRegex) {
            NamedRegex that = (NamedRegex)obj;
            return new EqualsBuilder().append((Object)this._name, (Object)that._name).append((Object)this._expression, (Object)that._expression).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._name).append((Object)this._expression).toHashCode();
    }

    public static List<NamedRegex> loadFromFile(File file) {
        ArrayList<NamedRegex> result = new ArrayList<NamedRegex>();
        BufferedReader reader = FileHelper.getBufferedReader((File)file);
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).startsWith("#")) {
                    int seperatorIndex = line.indexOf(61);
                    String name = line.substring(0, seperatorIndex);
                    String expression = line.substring(seperatorIndex + 1, line.length());
                    result.add(new NamedRegex(name, expression));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static void saveToFile(List<NamedRegex> regexes, File file) {
        StringBuilder sb = new StringBuilder();
        sb.append("#Regex registrations for DataCleaner\n");
        if (regexes != null) {
            for (NamedRegex namedRegex : regexes) {
                sb.append(namedRegex.getName() + "=" + namedRegex.getExpression() + "\n");
            }
        }
        FileHelper.writeStringAsFile((File)file, (String)sb.toString());
    }
}

