/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.catalog;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.profiler.pattern.Token;
import dk.eobjects.datacleaner.profiler.pattern.WordAndNumberTokenizer;
import dk.eobjects.metamodel.util.FileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFileDictionary
implements IDictionary {
    private static final long serialVersionUID = 6123460352476468574L;
    private static final Log _log = LogFactory.getLog(TextFileDictionary.class);
    private transient ArrayList<String> _wordList;
    private File _dictionaryFile;
    private String _name;

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public File getDictionaryFile() {
        return this._dictionaryFile;
    }

    public void setDictionaryFile(File dictionaryFile) {
        this._dictionaryFile = dictionaryFile;
    }

    public TextFileDictionary() {
    }

    public TextFileDictionary(File dictionaryFile) {
        this.setDictionaryFile(dictionaryFile);
    }

    public TextFileDictionary(String name, File file) {
        this.setName(name);
        this.setDictionaryFile(file);
    }

    private void initWordlist() {
        if (this._dictionaryFile == null) {
            throw new IllegalStateException("Cannot validate without dictionaryFile.");
        }
        try {
            BufferedReader br = new BufferedReader(FileHelper.getReader((File)this._dictionaryFile));
            this._wordList = new ArrayList();
            String line = br.readLine();
            while (line != null) {
                line = line.trim();
                this._wordList.add(line);
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            _log.error((Object)e);
            throw new RuntimeException(e);
        }
        Collections.sort(this._wordList);
    }

    public boolean[] isValid(String ... values) {
        if (this._wordList == null) {
            this.initWordlist();
        }
        WordAndNumberTokenizer tokenizer = new WordAndNumberTokenizer();
        boolean[] results = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            results[i] = true;
            String sentence = values[i];
            Token[] tokens = tokenizer.tokenize(sentence);
            boolean debugEnabled = _log.isDebugEnabled();
            if (debugEnabled) {
                _log.debug((Object)("Spell checking sentence: " + sentence));
                _log.debug((Object)("Found tokens: " + ArrayUtils.toString((Object)tokens)));
            }
            for (int j = 0; j < tokens.length && results[i]; ++j) {
                if (!tokens[j].isWord() && !tokens[j].isMixed()) continue;
                String tokenString = tokens[j].toString();
                results[i] = this.existsInFile(tokenString);
                if (!debugEnabled || results[i]) continue;
                _log.debug((Object)("Token '" + tokenString + "' was not valid according to spell checker."));
            }
        }
        return results;
    }

    private boolean existsInFile(String word) {
        int binarySearch = Collections.binarySearch(this._wordList, word);
        return binarySearch >= 0;
    }

    public String toString() {
        return "TextFileDictionary[name=" + this._name + "]";
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

