/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.comparator;

import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnComparator {
    private static final Log _log = LogFactory.getLog(ColumnComparator.class);
    private Map<Object, Map<Column, Long>> _valueCounts = new HashMap<Object, Map<Column, Long>>();
    private Column[] _columns;

    public Column[] getColumns() {
        return this._columns;
    }

    public void initialize(Column ... columns) {
        this._columns = columns;
        ColumnType type = null;
        for (Column column : columns) {
            if (type == null) {
                type = column.getType();
                continue;
            }
            if (type == column.getType()) continue;
            _log.warn((Object)("Columns are of different types, which may make them incomparable: " + ArrayUtils.toString((Object)columns)));
        }
    }

    public void processValue(Column column, Object value, long count) {
        Map<Column, Long> valueCount = this._valueCounts.get(value);
        if (valueCount == null) {
            valueCount = new HashMap<Column, Long>();
            this._valueCounts.put(value, valueCount);
        }
        valueCount.put(column, count);
        if (this.cleanValueCount(valueCount)) {
            this._valueCounts.remove(value);
        }
    }

    public IMatrix getResult() {
        MatrixBuilder mb = new MatrixBuilder();
        for (int i = 0; i < this._columns.length; ++i) {
            mb.addColumn(this._columns[i].getName(), new Object[0]);
        }
        Set<Map.Entry<Object, Map<Column, Long>>> entries = this._valueCounts.entrySet();
        for (Map.Entry<Object, Map<Column, Long>> entry : entries) {
            Object value = entry.getKey();
            Map<Column, Long> valueCount = entry.getValue();
            String valueName = "<null>";
            if (value != null) {
                valueName = value.toString();
            }
            Object[] counts = new Long[this._columns.length];
            for (int i = 0; i < this._columns.length; ++i) {
                Long count = valueCount.get(this._columns[i]);
                if (count == null) {
                    count = 0L;
                }
                counts[i] = count;
            }
            mb.addRow(valueName, counts);
        }
        mb.sortColumn(0, (short)1);
        return mb.getMatrix();
    }

    public IMatrix getResultForColumn(Column column) {
        MatrixBuilder mb = new MatrixBuilder();
        int columnIndex = 0;
        for (int i = 0; i < this._columns.length; ++i) {
            Column col = this._columns[i];
            if (col.equals((Object)column)) {
                columnIndex = i;
            }
            mb.addColumn(col.getName(), new Object[0]);
        }
        Set<Map.Entry<Object, Map<Column, Long>>> entries = this._valueCounts.entrySet();
        for (Map.Entry<Object, Map<Column, Long>> entry : entries) {
            Map<Column, Long> valueCount = entry.getValue();
            if (!valueCount.containsKey(column)) continue;
            Object value = entry.getKey();
            String valueName = "<null>";
            if (value != null) {
                valueName = value.toString();
            }
            Object[] counts = new Long[this._columns.length];
            for (int i = 0; i < this._columns.length; ++i) {
                Long count = valueCount.get(this._columns[i]);
                if (count == null) {
                    count = 0L;
                }
                counts[i] = count;
            }
            mb.addRow(valueName, counts);
        }
        mb.sortColumn(columnIndex, (short)1);
        return mb.getMatrix();
    }

    private boolean cleanValueCount(Map<Column, Long> valueCount) {
        if (valueCount.size() == this._columns.length) {
            Long globalCount = null;
            for (Column column : this._columns) {
                Long count = valueCount.get(column);
                if (count == null) {
                    return false;
                }
                if (globalCount == null) {
                    globalCount = count;
                    continue;
                }
                if (globalCount.equals(count)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

