/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.data;

import dk.eobjects.datacleaner.util.DomHelper;
import dk.eobjects.datacleaner.util.WeakObservable;
import dk.eobjects.metamodel.CsvDataContextStrategy;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.IDataContextStrategy;
import dk.eobjects.metamodel.XmlDataContextStrategy;
import dk.eobjects.metamodel.schema.TableType;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataContextSelection
extends WeakObservable {
    public static final String NODE_NAME = "dataContext";
    private DataContext _dataContext;
    private Connection _connectionObject;
    private Map<String, String> _connectionMetadata = new HashMap<String, String>();

    private DataContextSelection setDataContext(DataContext dataContext, Connection connectionObject) {
        if (this._connectionObject != null) {
            try {
                this._log.debug((Object)("closing previous connectionObject: " + this._connectionObject));
                this._connectionObject.close();
            }
            catch (Exception e) {
                this._log.warn((Object)("Could not close former connectionObject: " + e));
            }
        } else {
            this._log.debug((Object)"no previous connection object to close");
        }
        this._dataContext = dataContext;
        this._connectionObject = connectionObject;
        this.setChanged();
        this.notifyObservers();
        return this;
    }

    public DataContext getDataContext() {
        return this._dataContext;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._connectionObject != null) {
            try {
                this._connectionObject.close();
            }
            catch (Exception e) {
                this._log.warn((Object)("Could not close former connectionObject: " + e));
            }
        }
    }

    public void selectDatabase(String connectionString, String catalog, String username, String password, TableType[] tableTypes) throws SQLException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("selectDatabase(" + connectionString + ',' + catalog + ',' + username + ',' + password + ',' + ArrayUtils.toString((Object)tableTypes) + ")"));
        }
        if (tableTypes == null || tableTypes.length == 0) {
            tableTypes = new TableType[]{TableType.TABLE};
        }
        Connection connection = DriverManager.getConnection(connectionString, username, password);
        connection.setReadOnly(true);
        DataContext dc = new DataContext(connection, catalog, tableTypes);
        this.setDataContext(dc, connection);
        this._connectionMetadata.clear();
        this._connectionMetadata.put("connectionString", connectionString);
        this._connectionMetadata.put("catalog", catalog);
        this._connectionMetadata.put("username", username);
        this._connectionMetadata.put("password", password);
        this._connectionMetadata.put("tables", ArrayUtils.indexOf((Object[])tableTypes, (Object)TableType.TABLE) != -1 ? "true" : "false");
        this._connectionMetadata.put("views", ArrayUtils.indexOf((Object[])tableTypes, (Object)TableType.VIEW) != -1 ? "true" : "false");
    }

    public void selectFile(File file, char separatorChar, char quoteChar) {
        if (this._log.isDebugEnabled() && file != null) {
            this._log.debug((Object)("selectFile(" + file.getAbsolutePath() + ',' + separatorChar + ',' + quoteChar + ")"));
        }
        DataContext dc = new DataContext((IDataContextStrategy)new CsvDataContextStrategy(file, separatorChar, quoteChar));
        this.setDataContext(dc, null);
        this._connectionMetadata.clear();
        this._connectionMetadata.put("filename", file.getAbsolutePath());
        this._connectionMetadata.put("separator", "" + separatorChar);
        this._connectionMetadata.put("quoteChar", "" + quoteChar);
    }

    public void selectFile(File file) {
        DataContext dc;
        if (this._log.isDebugEnabled() && file != null) {
            this._log.debug((Object)("selectFile(" + file.getAbsolutePath() + ")"));
        }
        try {
            dc = new DataContext(file);
        }
        catch (Exception e1) {
            this._log.debug((Object)"Could not open file by using new DataContext(file)", (Throwable)e1);
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
                dc = new DataContext((IDataContextStrategy)new XmlDataContextStrategy(file.getName(), document, true));
            }
            catch (Exception e2) {
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)e2;
                }
                throw new IllegalArgumentException(e2);
            }
        }
        this.setDataContext(dc, null);
        this._connectionMetadata.clear();
        this._connectionMetadata.put("filename", file.getAbsolutePath());
    }

    public void selectNothing() {
        this._log.debug((Object)"selectNothing()");
        this.setDataContext(null, null);
        this._connectionMetadata.clear();
    }

    public Element serialize(Document document) {
        Element dataContextElement = document.createElement(NODE_NAME);
        DomHelper.addPropertyNodes(document, dataContextElement, this._connectionMetadata);
        return dataContextElement;
    }

    public static DataContextSelection deserialize(Node node) throws SQLException {
        if (!NODE_NAME.equals(node.getNodeName())) {
            throw new IllegalArgumentException("Node name must be 'dataContext', found '" + node.getNodeName() + "'");
        }
        Map<String, String> properties = DomHelper.getPropertiesFromChildNodes(node);
        DataContextSelection dcs = new DataContextSelection();
        if (properties.containsKey("filename")) {
            File file = new File(properties.get("filename"));
            String seperatorString = properties.get("separator");
            String quoteCharString = properties.get("quoteChar");
            if (seperatorString != null && seperatorString.length() == 1 && quoteCharString != null && quoteCharString.length() == 1) {
                dcs.selectFile(file, seperatorString.charAt(0), quoteCharString.charAt(0));
            } else {
                dcs.selectFile(file);
            }
        } else if (properties.containsKey("connectionString")) {
            String connectionString = properties.get("connectionString");
            String catalog = properties.get("catalog");
            String username = properties.get("username");
            String password = properties.get("password");
            ArrayList<TableType> tableTypes = new ArrayList<TableType>();
            if ("true".equals(properties.get("tables"))) {
                tableTypes.add(TableType.TABLE);
            }
            if ("true".equals(properties.get("views"))) {
                tableTypes.add(TableType.VIEW);
            }
            dcs.selectDatabase(connectionString, catalog, username, password, tableTypes.toArray(new TableType[tableTypes.size()]));
        } else {
            throw new IllegalArgumentException("Could not determine type of DataContext in DataContextSelection deserialization. Properties: " + properties.toString());
        }
        return dcs;
    }
}

