/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.execution;

import dk.eobjects.datacleaner.execution.IProgressObserver;
import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.execution.IRunner;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.MetaModelHelper;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.FromItem;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunner<E extends IRunnableConfiguration, F, G>
implements IRunner<E, F> {
    protected Log _log = LogFactory.getLog(this.getClass());
    protected Map<Table, List<F>> _results = new HashMap<Table, List<F>>();
    protected List<E> _configurations = new ArrayList();
    private List<IProgressObserver> _progressObservers = new ArrayList<IProgressObserver>();

    @Override
    public void addConfiguration(E configuration) {
        this._configurations.add(configuration);
    }

    @Override
    public void execute(DataContext dataContext) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"execute() beginning");
                this._log.debug((Object)("data context: " + dataContext));
                this._log.debug((Object)("progress observers: " + ArrayUtils.toString(this._progressObservers)));
            }
            List<Column> columns = this.getAllColumns();
            Table[] tables = MetaModelHelper.getTables(columns);
            this.initObservers(tables);
            for (int i = 0; i < tables.length; ++i) {
                Table table = tables[i];
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("querying table: " + table.getName()));
                }
                this.notifyExecutionBegin(table);
                try {
                    Map<E, Column[]> configurations = this.getConfigurationsForTable(table);
                    G[] processors = this.initConfigurations(configurations);
                    Column[] columnsToQuery = this.getColumnsToQuery(configurations);
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("querying columns: " + ArrayUtils.toString((Object)columnsToQuery)));
                    }
                    Query q = new Query();
                    q.from(new FromItem[]{new FromItem(table).setAlias("t")});
                    q.select(columnsToQuery);
                    SelectItem countAllItem = SelectItem.getCountAllItem();
                    q.select(new SelectItem[]{countAllItem});
                    q.groupBy(columnsToQuery);
                    DataSet data = dataContext.executeQuery(q);
                    int rowNumber = 0;
                    while (data.next()) {
                        Row row = data.getRow();
                        Object countValue = row.getValue(countAllItem);
                        Long count = countValue instanceof Long ? (Long)countValue : (countValue instanceof Number ? Long.valueOf(((Number)countValue).longValue()) : new Long(countValue.toString()));
                        for (int j = 0; j < processors.length; ++j) {
                            G processor = processors[j];
                            this.processRow(row, count, processor);
                        }
                        if (++rowNumber % 500 != 0 || !this._log.isInfoEnabled()) continue;
                        this._log.info((Object)("Processing row number: " + rowNumber));
                    }
                    for (int j = 0; j < processors.length; ++j) {
                        G processor = processors[j];
                        F result = this.getResult(processor);
                        this.addResultForTable(table, result);
                    }
                }
                catch (Throwable t) {
                    this._log.error((Object)t);
                    this.notifyExecutionFailed(table, t);
                }
                this.notifyExecutionSuccess(table);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"execute() finished");
            }
        }
        catch (Throwable t) {
            this._log.fatal((Object)t);
        }
    }

    private void initObservers(Table[] tables) {
        for (IProgressObserver observer : this._progressObservers) {
            observer.init(tables);
        }
    }

    private void notifyExecutionSuccess(Table table) {
        for (IProgressObserver observer : this._progressObservers) {
            observer.notifyExecutionSuccess(table);
        }
    }

    private void notifyExecutionFailed(Table table, Throwable t) {
        for (IProgressObserver observer : this._progressObservers) {
            observer.notifyExecutionFailed(table, t);
        }
    }

    private void notifyExecutionBegin(Table table) {
        for (IProgressObserver observer : this._progressObservers) {
            observer.notifyExecutionBegin(table);
        }
    }

    protected abstract G[] initConfigurations(Map<E, Column[]> var1);

    protected abstract void processRow(Row var1, long var2, G var4);

    protected abstract F getResult(G var1);

    private Column[] getColumnsToQuery(Map<E, Column[]> configurations) {
        ArrayList<Column> result = new ArrayList<Column>();
        for (Map.Entry<E, Column[]> entry : configurations.entrySet()) {
            Column[] columns = entry.getValue();
            for (int i = 0; i < columns.length; ++i) {
                if (result.contains(columns[i])) continue;
                result.add(columns[i]);
            }
        }
        return result.toArray(new Column[result.size()]);
    }

    private Map<E, Column[]> getConfigurationsForTable(Table table) {
        HashMap<IRunnableConfiguration, Column[]> result = new HashMap<IRunnableConfiguration, Column[]>();
        for (IRunnableConfiguration configuration : this._configurations) {
            Column[] columns = configuration.getColumns();
            Column[] tableColumns = MetaModelHelper.getTableColumns((Table)table, (Column[])columns);
            if (tableColumns.length <= 0) continue;
            result.put(configuration, tableColumns);
        }
        return result;
    }

    @Override
    public List<F> getResults() {
        ArrayList<F> results = new ArrayList<F>();
        Collection<List<F>> values = this._results.values();
        for (List<F> list : values) {
            results.addAll(list);
        }
        return results;
    }

    protected List<Column> getAllColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        for (IRunnableConfiguration configuration : this._configurations) {
            Column[] columns = configuration.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                Column column = columns[i];
                if (result.contains(column)) continue;
                result.add(column);
            }
        }
        return result;
    }

    @Override
    public Table[] getResultTables() {
        Set<Table> tableSet = this._results.keySet();
        return tableSet.toArray(new Table[tableSet.size()]);
    }

    @Override
    public List<F> getResultsForTable(Table table) {
        return this._results.get(table);
    }

    protected void addResultForTable(Table table, F result) {
        List<F> resultsForTable = this._results.get(table);
        if (resultsForTable == null) {
            resultsForTable = new ArrayList<F>();
        }
        resultsForTable.add(result);
        this._results.put(table, resultsForTable);
    }

    @Override
    public void addProgressObserver(IProgressObserver observer) {
        this._progressObservers.add(observer);
    }

    public void removeProgressObserver(IProgressObserver observer) {
        this._progressObservers.remove(observer);
    }
}

