/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.execution;

import dk.eobjects.datacleaner.execution.AbstractRunner;
import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.profiler.IProfileResult;
import dk.eobjects.datacleaner.profiler.ProfileConfiguration;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileRunner
extends AbstractRunner<ProfileConfiguration, IProfileResult, IProfile> {
    protected IProfile[] initConfigurations(Map<ProfileConfiguration, Column[]> configurations) {
        ArrayList<IProfile> result = new ArrayList<IProfile>();
        for (Map.Entry<ProfileConfiguration, Column[]> entry : configurations.entrySet()) {
            ProfileConfiguration configuration = entry.getKey();
            Column[] columns = entry.getValue();
            IProfile profile = this.initProfile(configuration, columns);
            result.add(profile);
        }
        return result.toArray(new IProfile[result.size()]);
    }

    private IProfile initProfile(ProfileConfiguration configuration, Column[] columns) {
        Class<? extends IProfile> profileClass = configuration.getProfileDescriptor().getProfileClass();
        try {
            IProfile profile = profileClass.newInstance();
            profile.setProperties(configuration.getProfileProperties());
            profile.initialize(columns);
            return profile;
        }
        catch (InstantiationException e) {
            this._log.fatal((Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            this._log.fatal((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void processRow(Row row, long count, IProfile processor) {
        processor.process(row, count);
    }

    @Override
    protected IProfileResult getResult(IProfile processor) {
        return processor.getResult();
    }
}

