/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.execution;

import dk.eobjects.datacleaner.execution.AbstractRunner;
import dk.eobjects.datacleaner.validator.IValidationRule;
import dk.eobjects.datacleaner.validator.IValidationRuleResult;
import dk.eobjects.datacleaner.validator.ValidationRuleConfiguration;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleRunner
extends AbstractRunner<ValidationRuleConfiguration, IValidationRuleResult, IValidationRule> {
    protected IValidationRule[] initConfigurations(Map<ValidationRuleConfiguration, Column[]> configurations) {
        ArrayList<IValidationRule> result = new ArrayList<IValidationRule>();
        for (Map.Entry<ValidationRuleConfiguration, Column[]> entry : configurations.entrySet()) {
            ValidationRuleConfiguration configuration = entry.getKey();
            Column[] columns = entry.getValue();
            IValidationRule vr = this.initValidationRule(configuration, columns);
            result.add(vr);
        }
        return result.toArray(new IValidationRule[result.size()]);
    }

    private IValidationRule initValidationRule(ValidationRuleConfiguration configuration, Column[] columns) {
        Class<? extends IValidationRule> validationRuleClass = configuration.getValidationRuleDescriptor().getValidationRuleClass();
        try {
            IValidationRule vr = validationRuleClass.newInstance();
            vr.setProperties(configuration.getValidationRuleProperties());
            vr.initialize(columns);
            return vr;
        }
        catch (InstantiationException e) {
            this._log.fatal((Object)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            this._log.fatal((Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected IValidationRuleResult getResult(IValidationRule processor) {
        IValidationRuleResult result = processor.getResult();
        return result;
    }

    @Override
    protected void processRow(Row row, long count, IValidationRule processor) {
        processor.process(row, count);
    }
}

