/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.profiler.IProfileResult;
import dk.eobjects.datacleaner.profiler.ProfileResult;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Table;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfile
implements IProfile {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected long _totalCount;
    protected Column[] _columns;
    protected Map<String, String> _properties;
    private Exception _error = null;

    @Override
    public void setProperties(Map<String, String> properties) {
        this._properties = properties;
    }

    @Override
    public void initialize(Column ... columns) {
        this._columns = columns;
    }

    @Override
    public void process(Row row, long distinctRowCount) {
        this._totalCount += distinctRowCount;
        if (this._error == null) {
            try {
                for (int i = 0; i < this._columns.length; ++i) {
                    Column column = this._columns[i];
                    Object value = row.getValue(column);
                    this.processValue(column, value, distinctRowCount, row);
                }
            }
            catch (Exception e) {
                this._error = e;
            }
        }
    }

    protected Query getBaseQuery() {
        if (this._columns.length > 0) {
            Table table = this._columns[0].getTable();
            Query q = new Query().select(table.getColumns()).from(table);
            return q;
        }
        return null;
    }

    protected Query getBaseQuery(Column column) {
        return new Query().from(column.getTable()).select(new SelectItem[]{new SelectItem(column)}).selectCount().groupBy(new Column[]{column});
    }

    protected Integer getPropertyInteger(String propertyName) {
        Integer result = null;
        String resultString = this._properties.get(propertyName);
        if (resultString != null && !"".equals(resultString)) {
            try {
                result = Integer.parseInt(resultString);
            }
            catch (NumberFormatException e) {
                this._log.warn((Object)("Couldn't parse integer for property '" + propertyName + "': " + e.getMessage()));
            }
        }
        return result;
    }

    protected abstract void processValue(Column var1, Object var2, long var3, Row var5);

    @Override
    public IProfileResult getResult() {
        ProfileResult result = new ProfileResult(this.getClass());
        if (this._error == null) {
            if (this._totalCount > 0L) {
                result.setMatrices(this.getResultMatrices());
            } else {
                result.setError(new Exception("No rows in selected data to profile!"));
            }
        } else {
            result.setError(this._error);
        }
        return result;
    }

    protected abstract List<IMatrix> getResultMatrices();
}

