/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.metamodel.schema.ColumnType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicProfileDescriptor
implements IProfileDescriptor {
    private static final long serialVersionUID = 7463620056978325219L;
    private static final String PROPERTY_CONSTANT_PREFIX = "PROPERTY_";
    private static final Log _log = LogFactory.getLog(BasicProfileDescriptor.class);
    private String _displayName;
    private Class<? extends IProfile> _profileClass;
    private boolean _datesRequired = false;
    private boolean _literalsRequired = false;
    private boolean _numbersRequired = false;
    private String[] _propertyNames;
    private String _iconPath;

    public void setDatesRequired(boolean datesRequired) {
        this._datesRequired = datesRequired;
    }

    public void setLiteralsRequired(boolean literalsRequired) {
        this._literalsRequired = literalsRequired;
    }

    public void setNumbersRequired(boolean numbersRequired) {
        this._numbersRequired = numbersRequired;
    }

    public BasicProfileDescriptor(String displayName, Class<? extends IProfile> profileClass) {
        this._displayName = displayName;
        this._profileClass = profileClass;
    }

    public BasicProfileDescriptor() {
    }

    @Override
    public boolean isSupported(ColumnType type) {
        if (this._datesRequired && !type.isTimeBased()) {
            return false;
        }
        if (this._literalsRequired && !type.isLiteral()) {
            return false;
        }
        return !this._numbersRequired || type.isNumber();
    }

    public String toString() {
        return "BasicProfileDescriptor[displayName=" + this._displayName + ",profileClass=" + this._profileClass + "]";
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    @Override
    public Class<? extends IProfile> getProfileClass() {
        return this._profileClass;
    }

    public void setProfileClass(Class<? extends IProfile> profileClass) {
        this._profileClass = profileClass;
    }

    @Override
    public String[] getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        if (this._propertyNames != null) {
            for (int i = 0; i < this._propertyNames.length; ++i) {
                result.add(this._propertyNames[i]);
            }
        }
        if (this._profileClass != null) {
            this.addConstantValues(result, this._profileClass);
        }
        return result.toArray(new String[result.size()]);
    }

    private void addConstantValues(List<String> result, Class<? extends Object> clazz) {
        Field[] constants = ReflectionHelper.getConstants(clazz);
        for (int i = 0; i < constants.length; ++i) {
            Field constant = constants[i];
            if (!constant.getName().startsWith(PROPERTY_CONSTANT_PREFIX)) continue;
            try {
                result.add(constant.get(null).toString());
                continue;
            }
            catch (IllegalArgumentException e) {
                _log.error((Object)e);
                continue;
            }
            catch (IllegalAccessException e) {
                _log.error((Object)e);
            }
        }
    }

    public void setPropertyNames(String[] propertyNames) {
        this._propertyNames = propertyNames;
    }

    @Override
    public String getIconPath() {
        return this._iconPath;
    }

    public void setIconPath(String iconPath) {
        this._iconPath = iconPath;
    }
}

