/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.datacleaner.profiler.SimpleMatrix;
import dk.eobjects.metamodel.util.ObjectComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatrixBuilder {
    public static final short ASCENDING = 0;
    public static final short DESCENDING = 1;
    private static Log _log = LogFactory.getLog(MatrixBuilder.class);
    private List<String> _columnNames = new ArrayList<String>();
    private List<String> _rowNames = new ArrayList<String>();
    private List<List<MatrixValue>> _content = new ArrayList<List<MatrixValue>>();

    public MatrixValue[] addColumn(String columnName, Object ... values) throws IllegalArgumentException {
        if (values.length != this._rowNames.size()) {
            throw new IllegalArgumentException("Invalid size of values, expected: " + this._rowNames.size() + ", actual: " + values.length);
        }
        this._columnNames.add(columnName);
        MatrixValue[] result = new MatrixValue[this._content.size()];
        for (int i = 0; i < this._content.size(); ++i) {
            List<MatrixValue> row = this._content.get(i);
            MatrixValue mv = new MatrixValue(values[i]);
            row.add(mv);
            result[i] = mv;
        }
        return result;
    }

    public MatrixValue[] addRow(String rowName, Object ... values) throws IllegalArgumentException {
        if (values.length != this._columnNames.size()) {
            throw new IllegalArgumentException("Invalid size of values, expected: " + this._columnNames.size() + ", actual: " + values.length);
        }
        this._rowNames.add(rowName);
        ArrayList<MatrixValue> row = new ArrayList<MatrixValue>();
        for (Object value : values) {
            row.add(new MatrixValue(value));
        }
        this._content.add(row);
        return row.toArray(new MatrixValue[row.size()]);
    }

    public IMatrix getMatrix() {
        SimpleMatrix matrix = new SimpleMatrix(this._columnNames.toArray(new String[this._columnNames.size()]), this._rowNames.toArray(new String[this._rowNames.size()]), this.getContentArray());
        return matrix;
    }

    private MatrixValue[][] getContentArray() {
        MatrixValue[][] contentArray = new MatrixValue[this._rowNames.size()][this._columnNames.size()];
        for (int i = 0; i < this._content.size(); ++i) {
            List<MatrixValue> row = this._content.get(i);
            for (int j = 0; j < row.size(); ++j) {
                MatrixValue value;
                contentArray[i][j] = value = row.get(j);
            }
        }
        return contentArray;
    }

    public MatrixValue replaceValue(int rowIndex, int columnIndex, Object value) throws IllegalArgumentException {
        try {
            List<MatrixValue> row = this._content.get(rowIndex);
            MatrixValue mv = new MatrixValue(value);
            row.set(columnIndex, mv);
            return mv;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public MatrixValue replaceValue(String columnName, String rowName, Object value) throws IllegalArgumentException {
        int columnIndex = ArrayUtils.indexOf((Object[])this._columnNames.toArray(new String[this._columnNames.size()]), (Object)columnName);
        int rowIndex = ArrayUtils.indexOf((Object[])this._rowNames.toArray(new String[this._rowNames.size()]), (Object)rowName);
        return this.replaceValue(rowIndex, columnIndex, value);
    }

    public MatrixValue getMatrixValue(int rowIndex, int columnIndex) {
        return this._content.get(rowIndex).get(columnIndex);
    }

    public void sortColumn(int columnIndex, short direction) {
        Comparator comparator = ObjectComparator.getComparator();
        Object[] unSortedColumn = new Object[this._rowNames.size()];
        for (int i = 0; i < this._content.size(); ++i) {
            List<MatrixValue> row = this._content.get(i);
            MatrixValue value = row.get(columnIndex);
            unSortedColumn[i] = value;
        }
        _log.debug((Object)("Unsorted column: " + ArrayUtils.toString((Object)unSortedColumn)));
        Object[] sortedColumn = (Object[])unSortedColumn.clone();
        Arrays.sort(sortedColumn, comparator);
        if (direction == 1) {
            ArrayUtils.reverse((Object[])sortedColumn);
        }
        _log.debug((Object)("Sorted column: " + ArrayUtils.toString((Object)sortedColumn)));
        Object[] newIndexes = new Integer[this._rowNames.size()];
        Arrays.fill(newIndexes, (Object)-1);
        HashMap<Object, Integer> valueCount = new HashMap<Object, Integer>();
        for (int unsortedIndex = 0; unsortedIndex < unSortedColumn.length; ++unsortedIndex) {
            Object value = unSortedColumn[unsortedIndex];
            Integer count = (Integer)valueCount.get(value);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            valueCount.put(value, count);
            int sortedIndex = ArrayUtils.indexOf((Object[])sortedColumn, (Object)value);
            newIndexes[unsortedIndex] = sortedIndex - 1 + count;
        }
        valueCount = null;
        _log.debug((Object)("New indexes : " + ArrayUtils.toString((Object)newIndexes)));
        MatrixValue[][] origContent = this.getContentArray();
        for (int i = 0; i < origContent.length; ++i) {
            MatrixValue[] origRow = origContent[i];
            for (int j = 0; j < origRow.length; ++j) {
                MatrixValue oldValue = origContent[i][j];
                this._content.get((Integer)newIndexes[i]).set(j, oldValue);
            }
        }
        String[] origRowNames = this._rowNames.toArray(new String[this._rowNames.size()]);
        for (int i = 0; i < origRowNames.length; ++i) {
            this._rowNames.set((Integer)newIndexes[i], origRowNames[i]);
        }
    }

    public void sortColumn(String columnName, short direction) {
        int columnIndex = ArrayUtils.indexOf((Object[])this._columnNames.toArray(new String[this._columnNames.size()]), (Object)columnName);
        this.sortColumn(columnIndex, direction);
    }

    public boolean isEmpty() {
        return this._columnNames.size() == 0 || this._rowNames.size() == 0;
    }

    public int getRowCount() {
        return this._rowNames.size();
    }

    public int getColumnCount() {
        return this._columnNames.size();
    }
}

