/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.ProfilerManager;
import dk.eobjects.datacleaner.util.DomHelper;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileConfiguration
implements IRunnableConfiguration {
    public static final String NODE_NAME = "configuration";
    private static final long serialVersionUID = -3296880963830262834L;
    private IProfileDescriptor _profileDescriptor;
    private Map<String, String> _profileProperties = new HashMap<String, String>();
    private Column[] _columns;

    public ProfileConfiguration() {
    }

    public ProfileConfiguration(IProfileDescriptor profileDescriptor) {
        this();
        this.setProfileDescriptor(profileDescriptor);
    }

    public IProfileDescriptor getProfileDescriptor() {
        return this._profileDescriptor;
    }

    public void setProfileDescriptor(IProfileDescriptor profileDescriptor) {
        this._profileDescriptor = profileDescriptor;
    }

    public Map<String, String> getProfileProperties() {
        return this._profileProperties;
    }

    public void setProfileProperties(Map<String, String> profileProperties) {
        this._profileProperties = profileProperties;
    }

    public void addProfileProperty(String property, String value) {
        this._profileProperties.put(property, value);
    }

    public void setColumns(Column ... columns) {
        this._columns = columns;
    }

    public void setColumns(List<Column> columns) {
        this._columns = columns.toArray(new Column[columns.size()]);
    }

    @Override
    public Column[] getColumns() {
        if (this._columns == null) {
            return new Column[0];
        }
        return this._columns;
    }

    public String toString() {
        return "ProfileConfiguration[profileDescriptor=" + this._profileDescriptor + ",columns=" + ArrayUtils.toString((Object)this._columns) + ",properties=" + this._profileProperties.toString() + "]";
    }

    public static ProfileConfiguration deserialize(Node node, DataContext dc) throws IllegalArgumentException {
        if (!NODE_NAME.equals(node.getNodeName())) {
            throw new IllegalArgumentException("Node name must be 'configuration', found '" + node.getNodeName() + "'");
        }
        String profileClassName = DomHelper.getAttributeValue(node, "profileClass");
        IProfileDescriptor profileDescriptor = ProfilerManager.getProfileDescriptorByProfileClassName(profileClassName);
        if (profileDescriptor == null) {
            throw new IllegalArgumentException("Could not resolve profileClass '" + profileClassName + "'");
        }
        ProfileConfiguration configuration = new ProfileConfiguration(profileDescriptor);
        Map<String, String> properties = DomHelper.getPropertiesFromChildNodes(node);
        configuration.setProfileProperties(properties);
        List<Column> columns = DomHelper.getColumnsFromChildNodes(node, dc);
        configuration.setColumns(columns);
        return configuration;
    }

    public Element serialize(Document document) {
        Element configurationElement = document.createElement(NODE_NAME);
        String profileClass = this.getProfileDescriptor().getProfileClass().getName();
        configurationElement.setAttribute("profileClass", profileClass);
        Map<String, String> properties = this.getProfileProperties();
        DomHelper.addPropertyNodes(document, configurationElement, properties);
        Column[] columns = this.getColumns();
        DomHelper.addColumnNodes(document, configurationElement, columns);
        return configurationElement;
    }
}

