/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import dk.eobjects.datacleaner.profiler.IProfileResult;
import dk.eobjects.datacleaner.profiler.ProfilerManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileResult
implements IProfileResult {
    private List<IMatrix> _matrices = new ArrayList<IMatrix>();
    private IProfileDescriptor _profileDescriptor;
    private Exception _error;

    public ProfileResult(IProfileDescriptor profileDescriptor) {
        this._profileDescriptor = profileDescriptor;
    }

    public ProfileResult(Class<? extends IProfile> profileClass) {
        this._profileDescriptor = ProfilerManager.getProfileDescriptorByProfileClass(profileClass);
    }

    @Override
    public IMatrix[] getMatrices() {
        return this._matrices.toArray(new IMatrix[this._matrices.size()]);
    }

    public void addMatrix(IMatrix matrix) {
        this._matrices.add(matrix);
    }

    public String toString() {
        return "ProfileResult[profileDescriptor=" + this._profileDescriptor + ",matrices=" + ArrayUtils.toString((Object)this.getMatrices()) + "]";
    }

    @Override
    public IProfileDescriptor getDescriptor() {
        return this._profileDescriptor;
    }

    public void setMatrices(List<IMatrix> matrices) {
        this._matrices = matrices;
    }

    @Override
    public Exception getError() {
        return this._error;
    }

    public void setError(Exception error) {
        this._error = error;
    }
}

