/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IProfile;
import dk.eobjects.datacleaner.profiler.IProfileDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilerManager {
    private static List<IProfileDescriptor> _profileDescriptors = new ArrayList<IProfileDescriptor>();
    private static Log _log = LogFactory.getLog(ProfilerManager.class);

    private ProfilerManager() {
    }

    public static IProfileDescriptor[] getProfileDescriptors() {
        return _profileDescriptors.toArray(new IProfileDescriptor[_profileDescriptors.size()]);
    }

    public static IProfileDescriptor getProfileDescriptorByProfileClass(Class<? extends IProfile> profileClass) {
        if (profileClass != null) {
            for (IProfileDescriptor profileDescriptor : _profileDescriptors) {
                if (profileClass != profileDescriptor.getProfileClass()) continue;
                return profileDescriptor;
            }
        }
        return null;
    }

    public static IProfileDescriptor getProfileDescriptorByProfileClassName(String className) {
        if (className != null) {
            for (IProfileDescriptor profileDescriptor : _profileDescriptors) {
                if (!className.equals(profileDescriptor.getProfileClass().getName())) continue;
                return profileDescriptor;
            }
        }
        return null;
    }

    public static void setProfileDescriptors(List<IProfileDescriptor> profileDescriptors) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting profile descriptors: " + ArrayUtils.toString(profileDescriptors)));
        }
        _profileDescriptors = profileDescriptors;
    }

    public static void addProfileDescriptor(IProfileDescriptor profileDescriptor) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding profile descriptor: " + profileDescriptor));
        }
        _profileDescriptors.add(profileDescriptor);
    }
}

