/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler;

import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import java.util.StringTokenizer;
import org.apache.commons.lang.ArrayUtils;

class SimpleMatrix
implements IMatrix {
    private String[] _columns;
    private String[] _rows;
    private MatrixValue[][] _values;

    public SimpleMatrix(String[] columns, String[] rows, MatrixValue[][] values) {
        this._columns = columns;
        this._rows = rows;
        this._values = values;
    }

    public SimpleMatrix(String columns, String rows, MatrixValue[][] values) {
        this._columns = this.tokenize(columns);
        this._rows = this.tokenize(rows);
        this._values = values;
    }

    private String[] tokenize(String commaSeparatedString) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedString, ",");
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            result[i] = token.trim();
            ++i;
        }
        return result;
    }

    public String[] getColumnNames() {
        return this._columns;
    }

    public String[] getRowNames() {
        return this._rows;
    }

    public MatrixValue getValue(int rowNumber, int columnNumber) {
        return this._values[rowNumber][columnNumber];
    }

    public MatrixValue getValue(String rowName, String columnName) {
        int rowIndex = ArrayUtils.indexOf((Object[])this._rows, (Object)rowName);
        int columnIndex = ArrayUtils.indexOf((Object[])this._columns, (Object)columnName);
        return this.getValue(rowIndex, columnIndex);
    }

    public MatrixValue[][] getValues() {
        return this._values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Matrix[columnNames=" + ArrayUtils.toString((Object)this._columns));
        for (int i = 0; i < this._rows.length; ++i) {
            sb.append(',' + this._rows[i] + "=" + ArrayUtils.toString((Object)this._values[i]));
        }
        sb.append(']');
        return sb.toString();
    }
}

