/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.pattern;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.datacleaner.profiler.pattern.PatternRecognizer;
import dk.eobjects.metamodel.data.IRowFilter;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternFinderProfile
extends AbstractProfile {
    private Map<Column, PatternRecognizer> _patternRecognizers = new HashMap<Column, PatternRecognizer>();

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        PatternRecognizer patternRecognizer = this._patternRecognizers.get(column);
        if (patternRecognizer == null) {
            patternRecognizer = new PatternRecognizer();
            this._patternRecognizers.put(column, patternRecognizer);
        }
        if (value != null) {
            patternRecognizer.addInstance(value.toString(), valueCount);
        }
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        for (final Column column : this._columns) {
            MatrixBuilder mb = new MatrixBuilder();
            mb.addColumn(column.getName(), new Object[0]);
            final PatternRecognizer patternRecognizer = this._patternRecognizers.get(column);
            Map<String, Long> patterns = patternRecognizer.identifyPatterns();
            for (Map.Entry<String, Long> entry : patterns.entrySet()) {
                Long patternCount = entry.getValue();
                final String patternName = entry.getKey();
                MatrixValue[] matrixValues = mb.addRow(patternName, patternCount);
                MatrixValue mv = matrixValues[0];
                mv.setDetailSource(this.getBaseQuery(column));
                mv.addDetailRowFilter(new IRowFilter(){

                    public boolean accept(Row row) {
                        Object value = row.getValue(column);
                        if (value != null) {
                            return patternRecognizer.patternEquals(patternName, value.toString());
                        }
                        return false;
                    }
                });
            }
            if (mb.isEmpty()) continue;
            mb.sortColumn(0, (short)1);
            result.add(mb.getMatrix());
        }
        return result;
    }
}

