/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.pattern;

import dk.eobjects.datacleaner.profiler.pattern.ITokenizer;
import dk.eobjects.datacleaner.profiler.pattern.Token;
import dk.eobjects.datacleaner.profiler.pattern.WordAndNumberTokenizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternRecognizer {
    private ITokenizer _tokenizer = new WordAndNumberTokenizer();
    private Map<String, PatternDefinition> _patternMap = new TreeMap<String, PatternDefinition>();

    public void addInstance(String string, long count) {
        Token[] tokens = this._tokenizer.tokenize(string);
        String patternMapKey = PatternRecognizer.toPatternKey(tokens);
        PatternDefinition patternDefinition = this._patternMap.get(patternMapKey);
        if (patternDefinition == null) {
            patternDefinition = new PatternDefinition();
            this._patternMap.put(patternMapKey, patternDefinition);
        }
        patternDefinition.addInstanceData(tokens, count);
    }

    private static String toPatternKey(Token[] tokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            Token token = tokens[i];
            short type = token.getType();
            if (type == 2) {
                sb.append(token.toString());
                continue;
            }
            sb.append(type);
        }
        return sb.toString();
    }

    public Map<String, Long> identifyPatterns() {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        Collection<PatternDefinition> values = this._patternMap.values();
        for (PatternDefinition patternDefinition : values) {
            result.put(patternDefinition.toString(), patternDefinition.getCount());
        }
        return result;
    }

    public boolean patternEquals(String patternName, String value) {
        Token[] tokens = this._tokenizer.tokenize(value);
        String patternMapKey = PatternRecognizer.toPatternKey(tokens);
        PatternDefinition patternDefinition = this._patternMap.get(patternMapKey);
        if (patternDefinition != null) {
            return patternDefinition.toString().equals(patternName);
        }
        return false;
    }

    public Pattern getRegex(String patternName) {
        if (patternName != null) {
            Collection<PatternDefinition> values = this._patternMap.values();
            for (PatternDefinition patternDefinition : values) {
                if (!patternName.equals(patternDefinition.toString())) continue;
                String regex = patternDefinition.toRegex();
                return Pattern.compile(regex);
            }
        }
        return null;
    }

    private static class PatternDefinition {
        private long _count = 0L;
        private short[] _tokenTypes = null;
        private int[] _tokenLengths = null;
        private String[] _delimTokens = null;

        private PatternDefinition() {
        }

        public void addInstanceData(Token[] tokens, long count) {
            int i;
            if (this._tokenTypes == null && this._tokenLengths == null) {
                this._tokenTypes = new short[tokens.length];
                this._tokenLengths = new int[tokens.length];
                this._delimTokens = new String[tokens.length];
                for (i = 0; i < tokens.length; ++i) {
                    short type;
                    this._tokenTypes[i] = type = tokens[i].getType();
                    if (type != 2) continue;
                    this._delimTokens[i] = tokens[i].toString();
                }
            }
            this._count += count;
            for (i = 0; i < tokens.length; ++i) {
                int length = tokens[i].getLength();
                if (length <= this._tokenLengths[i]) continue;
                this._tokenLengths[i] = length;
            }
        }

        private String createSymbol(short tokenType, int length) {
            switch (tokenType) {
                case 3: {
                    return this.createSymbol('?', length);
                }
                case 1: {
                    return this.createSymbol('9', length);
                }
                case 0: {
                    return this.createSymbol('a', length);
                }
            }
            throw new IllegalArgumentException("Token had unsupported type.");
        }

        private String createSymbol(char repeatedChar, int length) {
            char[] result = new char[length];
            Arrays.fill(result, repeatedChar);
            return new String(result);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this._tokenTypes.length; ++i) {
                short type = this._tokenTypes[i];
                if (type == 2) {
                    sb.append(this._delimTokens[i]);
                    continue;
                }
                sb.append(this.createSymbol(this._tokenTypes[i], this._tokenLengths[i]));
            }
            return sb.toString();
        }

        public String toRegex() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this._tokenTypes.length; ++i) {
                short type = this._tokenTypes[i];
                if (type == 2) {
                    sb.append(new Token(this._delimTokens[i].toCharArray()).toRegex());
                    continue;
                }
                sb.append(new Token(type, this._tokenLengths[i]).toRegex());
            }
            return sb.toString();
        }

        public long getCount() {
            return this._count;
        }
    }
}

