/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.pattern;

import java.util.regex.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Token {
    public static final short TYPE_WORD = 0;
    public static final short TYPE_NUMBER = 1;
    public static final short TYPE_DELIM = 2;
    public static final short TYPE_MIXED = 3;
    private char[] _chars;
    private short _type = (short)-1;
    private Integer _length = null;

    public Token(char[] chars) {
        this._chars = chars;
    }

    public Token(short type, int length) {
        if (type == 2) {
            throw new IllegalArgumentException("Cannot create arbitrary DELIM tokens.");
        }
        this._type = type;
        this._length = length;
    }

    public short getType() {
        if (this._type == -1) {
            boolean foundLetter = false;
            boolean foundDigit = false;
            boolean foundDelim = false;
            for (int i = 0; i < this._chars.length; ++i) {
                if (Character.isLetter(this._chars[i])) {
                    foundLetter = true;
                    continue;
                }
                if (Character.isDigit(this._chars[i])) {
                    foundDigit = true;
                    continue;
                }
                foundDelim = true;
            }
            if (foundLetter && foundDigit && !foundDelim) {
                this._type = (short)3;
            } else if (foundLetter && !foundDigit && !foundDelim) {
                this._type = 0;
            } else if (!foundLetter && foundDigit && !foundDelim) {
                this._type = 1;
            } else if (!foundLetter && !foundDigit && foundDelim) {
                this._type = (short)2;
            } else {
                throw new IllegalStateException("Chars in Token contained both delim chars and letters/digits.");
            }
        }
        return this._type;
    }

    public int getLength() {
        if (this._length == null) {
            this._length = this._chars.length;
        }
        return this._length;
    }

    public boolean isWord() {
        return this.getType() == 0;
    }

    public boolean isDelimitor() {
        return this.getType() == 2;
    }

    public boolean isNumber() {
        return this.getType() == 1;
    }

    public boolean isMixed() {
        return this.getType() == 3;
    }

    public String toRegex() {
        short type = this.getType();
        StringBuilder sb = new StringBuilder();
        if (type == 2) {
            sb.append(Pattern.quote(new String(this._chars)));
        } else {
            if (type == 3) {
                sb.append("[a-zA-Z0-9]");
            } else if (type == 0) {
                sb.append("[a-zA-Z]");
            } else if (type == 1) {
                sb.append("[0-9]");
            }
            sb.append("{1," + this.getLength() + '}');
        }
        return sb.toString();
    }

    public String toString() {
        return new String(this._chars);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this._chars).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Token) {
            Token that = (Token)obj;
            return new EqualsBuilder().append(this.getType(), that.getType()).append(this.getLength(), that.getLength()).isEquals();
        }
        return false;
    }
}

