/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.datacleaner.util.SimpleEntry;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.data.IRowFilter;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryProfile
extends AbstractProfile {
    public static final String PROPERTY_BUFFER_SIZE = "Buffer size";
    public static final String PREFIX_PROPERTY_DICTIONARY = "dictionary_";
    private static final String NO_MATCHES = "No Matches";
    private static final String MULTIPLE_MATCHES = "Multiple Matches";
    private int _queryBufferSize = 50;
    private List<Map.Entry<Row, Long>> _bufferEntries = new ArrayList<Map.Entry<Row, Long>>();
    private List<IDictionary> _dictionaryList;
    private Map<Column, Map<IDictionary, Long>> _matches = new HashMap<Column, Map<IDictionary, Long>>();
    private Map<Column, List<String>> _multipleMatches = new HashMap<Column, List<String>>();
    private Map<Column, List<String>> _noMatches = new HashMap<Column, List<String>>();

    public int getQueryBufferSize() {
        return this._queryBufferSize;
    }

    public void setQueryBufferSize(int i) {
        this._queryBufferSize = i;
    }

    @Override
    public void initialize(Column ... columns) {
        List<String> dictionaryNames;
        super.initialize(columns);
        String bufferSizeStr = (String)this._properties.get(PROPERTY_BUFFER_SIZE);
        if (bufferSizeStr != null) {
            try {
                this._queryBufferSize = Integer.parseInt(bufferSizeStr);
            }
            catch (NumberFormatException e) {
                this._log.info((Object)e);
            }
        }
        if ((dictionaryNames = ReflectionHelper.getIteratedProperties(PREFIX_PROPERTY_DICTIONARY, this._properties)).isEmpty()) {
            throw new IllegalArgumentException("No dictionaries specified");
        }
        this._dictionaryList = new ArrayList<IDictionary>(dictionaryNames.size());
        for (String name : dictionaryNames) {
            IDictionary dictionary = DictionaryManager.getDictionaryByName(name);
            if (dictionary == null) {
                throw new IllegalArgumentException("No such dictionary, '" + name + "'");
            }
            this._dictionaryList.add(dictionary);
        }
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        this.processBuffer();
        ArrayList<IMatrix> resultMatrices = new ArrayList<IMatrix>();
        MatrixBuilder mb = new MatrixBuilder();
        for (IDictionary dic : this._dictionaryList) {
            mb.addRow(dic.getName(), new Object[0]);
        }
        mb.addRow(NO_MATCHES, new Object[0]);
        mb.addRow(MULTIPLE_MATCHES, new Object[0]);
        for (final Column column : this._columns) {
            Map<IDictionary, Long> dictionaryMatches = this._matches.get(column);
            if (dictionaryMatches == null) {
                dictionaryMatches = new HashMap<IDictionary, Long>();
            }
            ArrayList<String> colValues = new ArrayList<String>();
            for (IDictionary dictionary : this._dictionaryList) {
                Long matchCount = 0L;
                if (dictionaryMatches != null && (matchCount = dictionaryMatches.get(dictionary)) == null) {
                    matchCount = 0L;
                }
                colValues.add("" + matchCount);
            }
            List<String> noMatchesList = this._noMatches.get(column);
            int noMatchesCount = noMatchesList == null ? 0 : noMatchesList.size();
            colValues.add("" + noMatchesCount);
            List<String> multiMatchesList = this._multipleMatches.get(column);
            int multiMatchesCount = multiMatchesList == null ? 0 : multiMatchesList.size();
            colValues.add("" + multiMatchesCount);
            MatrixValue[] matrixValues = mb.addColumn(column.getName(), colValues.toArray());
            for (int i = 0; i < this._dictionaryList.size(); ++i) {
                final IDictionary dictionary = this._dictionaryList.get(i);
                MatrixValue matrixValue = matrixValues[i];
                if ("0".equals(matrixValue.getValue())) continue;
                matrixValue.setDetailSource(this.getBaseQuery(column)).addDetailRowFilter(new IRowFilter(){

                    public boolean accept(Row row) {
                        Object value = row.getValue(column);
                        return value != null && dictionary.isValid(value.toString())[0];
                    }
                });
            }
            if (noMatchesCount > 0) {
                MatrixValue matrixValue = matrixValues[matrixValues.length - 2];
                matrixValue.setDetailSource(this.createDataSet(column, noMatchesList));
            }
            if (multiMatchesCount <= 0) continue;
            MatrixValue matrixValue = matrixValues[matrixValues.length - 1];
            matrixValue.setDetailSource(this.createDataSet(column, multiMatchesList));
        }
        resultMatrices.add(mb.getMatrix());
        return resultMatrices;
    }

    private DataSet createDataSet(Column column, List<String> noMatchesList) {
        SelectItem[] selectItems = new SelectItem[]{new SelectItem(column)};
        ArrayList<Object[]> data = new ArrayList<Object[]>(noMatchesList.size());
        for (String string : noMatchesList) {
            data.add(new Object[]{string});
        }
        return new DataSet(selectItems, data);
    }

    @Override
    public void process(Row row, long distinctRowCount) {
        super.process(row, distinctRowCount);
        this._bufferEntries.add(new SimpleEntry<Row, Long>(row, distinctRowCount));
        int numValues = this._columns.length * this._bufferEntries.size();
        if (numValues >= this._queryBufferSize) {
            this.processBuffer();
        }
    }

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
    }

    private void processBuffer() {
        for (Column column : this._columns) {
            this.processColumn(column);
        }
        this._bufferEntries.clear();
    }

    private void processColumn(Column column) {
        int i;
        String queryValue;
        String[] queryValues = new String[this._bufferEntries.size()];
        for (int i2 = 0; i2 < this._bufferEntries.size(); ++i2) {
            Map.Entry<Row, Long> entry = this._bufferEntries.get(i2);
            Row row = entry.getKey();
            Object value = row.getValue(column);
            queryValue = null;
            if (value != null) {
                queryValue = value.toString();
            }
            queryValues[i2] = queryValue;
        }
        boolean[][] foundInDictionary = new boolean[this._dictionaryList.size()][];
        for (i = 0; i < this._dictionaryList.size(); ++i) {
            IDictionary dictionary = this._dictionaryList.get(i);
            foundInDictionary[i] = dictionary.isValid(queryValues);
        }
        for (int j = 0; j < this._bufferEntries.size(); ++j) {
            int numMatches = 0;
            for (int i3 = 0; i3 < this._dictionaryList.size(); ++i3) {
                if (!foundInDictionary[i3][j]) continue;
                ++numMatches;
            }
            if (numMatches != 0 && numMatches <= true) continue;
            Object value = this._bufferEntries.get(j).getKey().getValue(column);
            queryValue = null;
            if (value != null) {
                queryValue = value.toString();
            }
            if (numMatches == 0) {
                List<String> noMatchesList = this._noMatches.get(column);
                if (noMatchesList == null) {
                    noMatchesList = new ArrayList<String>();
                    this._noMatches.put(column, noMatchesList);
                }
                noMatchesList.add(queryValue);
            }
            if (numMatches <= 1) continue;
            List<String> multipleMatchesList = this._multipleMatches.get(column);
            if (multipleMatchesList == null) {
                multipleMatchesList = new ArrayList<String>();
                this._multipleMatches.put(column, multipleMatchesList);
            }
            multipleMatchesList.add(queryValue);
        }
        for (i = 0; i < this._dictionaryList.size(); ++i) {
            int resultIndex = 0;
            for (int j = 0; j < this._bufferEntries.size(); ++j) {
                Map.Entry<Row, Long> entry = this._bufferEntries.get(j);
                if (foundInDictionary[i][resultIndex]) {
                    Long matchCount;
                    IDictionary dictionary = this._dictionaryList.get(i);
                    Map<IDictionary, Long> dictionaryMatches = this._matches.get(column);
                    if (dictionaryMatches == null) {
                        dictionaryMatches = new HashMap<IDictionary, Long>();
                        this._matches.put(column, dictionaryMatches);
                    }
                    if ((matchCount = dictionaryMatches.get(dictionary)) == null) {
                        matchCount = 0L;
                    }
                    Long valueCount = entry.getValue();
                    matchCount = matchCount + valueCount;
                    dictionaryMatches.put(dictionary, matchCount);
                }
                ++resultIndex;
            }
        }
    }
}

