/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.FilterItem;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.util.FormatHelper;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.NumberFormatter;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.SummaryStatisticsImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberAnalysisProfile
extends AbstractProfile {
    private Map<Column, SummaryStatistics> _statistics = new HashMap<Column, SummaryStatistics>();
    private NumberFormat _numberFormat = FormatHelper.getUiNumberFormat();

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        SummaryStatistics statistics = this._statistics.get(column);
        if (statistics == null) {
            statistics = new SummaryStatisticsImpl();
            this._statistics.put(column, statistics);
        }
        if (value != null) {
            Double doubleValue = Double.parseDouble(value.toString());
            int i = 0;
            while ((long)i < valueCount) {
                statistics.addValue(doubleValue.doubleValue());
                ++i;
            }
        }
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        MatrixBuilder mb = new MatrixBuilder();
        mb.addRow("Highest value", new Object[0]);
        mb.addRow("Lowest value", new Object[0]);
        mb.addRow("Sum", new Object[0]);
        mb.addRow("Mean", new Object[0]);
        mb.addRow("Geometric mean", new Object[0]);
        mb.addRow("Standard deviation", new Object[0]);
        mb.addRow("Variance", new Object[0]);
        NumberFormatter nf = new NumberFormatter(this._numberFormat);
        for (int i = 0; i < this._columns.length; ++i) {
            try {
                SummaryStatistics s = this._statistics.get(this._columns[i]);
                double lowestValue = s.getMin();
                double highestValue = s.getMax();
                MatrixValue[] matrixValues = mb.addColumn(this._columns[i].getName(), nf.valueToString(highestValue), nf.valueToString(lowestValue), nf.valueToString(s.getSum()), nf.valueToString(s.getMean()), nf.valueToString(s.getGeometricMean()), nf.valueToString(s.getStandardDeviation()), nf.valueToString(s.getVariance()));
                matrixValues[0].setDetailSource(this.getBaseQuery().where(new FilterItem[]{new FilterItem(new SelectItem(this._columns[i]), OperatorType.EQUALS_TO, (Object)highestValue)}));
                matrixValues[1].setDetailSource(this.getBaseQuery().where(new FilterItem[]{new FilterItem(new SelectItem(this._columns[i]), OperatorType.EQUALS_TO, (Object)lowestValue)}));
                continue;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        if (!mb.isEmpty()) {
            result.add(mb.getMatrix());
        }
        return result;
    }
}

