/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.FilterItem;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class RepeatedValuesProfile
extends AbstractProfile {
    public static final String PROPERTY_SIGNIFICANCE_RATE = "Significance rate (%)";
    private Map<Column, Map<String, Long>> _repeatedValues = new HashMap<Column, Map<String, Long>>();
    private int _significanceRate = 5;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        String significanceRateString = (String)this._properties.get(PROPERTY_SIGNIFICANCE_RATE);
        if (significanceRateString != null) {
            try {
                this._significanceRate = Integer.parseInt(significanceRateString);
            }
            catch (NumberFormatException e) {
                this._log.error((Object)e);
            }
        }
    }

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        Long repeatCount;
        Map<String, Long> valueMap;
        String repeatedValue = null;
        if (value != null) {
            repeatedValue = value.toString();
        }
        if ((valueMap = this._repeatedValues.get(column)) == null) {
            valueMap = new HashMap<String, Long>();
            this._repeatedValues.put(column, valueMap);
        }
        if ((repeatCount = valueMap.get(repeatedValue)) == null) {
            repeatCount = 0L;
        }
        repeatCount = repeatCount + valueCount;
        if (value != null) {
            valueMap.put(repeatedValue, repeatCount);
        } else {
            valueMap.put(null, repeatCount);
        }
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        for (int i = 0; i < this._columns.length; ++i) {
            Column column = this._columns[i];
            Map<String, Long> valueMap = this._repeatedValues.get(column);
            MatrixBuilder mb = new MatrixBuilder();
            mb.addColumn(column.getName() + " count", new Object[0]);
            mb.addColumn(column.getName() + " %", new Object[0]);
            for (Map.Entry<String, Long> entry : valueMap.entrySet()) {
                Long repeatCount = entry.getValue();
                String value = entry.getKey();
                int repeatPercentage = (int)(repeatCount * 100L / this._totalCount);
                if (repeatPercentage < this._significanceRate) continue;
                MatrixValue[] matrixValues = mb.addRow(value, repeatCount, repeatPercentage + "%");
                matrixValues[0].setDetailSource(new Query().from(column.getTable()).select(this._columns).where(new FilterItem[]{new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, (Object)value)}));
            }
            if (mb.isEmpty()) continue;
            mb.sortColumn(0, (short)1);
            result.add(mb.getMatrix());
        }
        return result;
    }

    public void setSignificanceRate(int i) {
        this._significanceRate = i;
    }
}

