/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.FilterItem;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.util.ObjectComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardMeasuresProfile
extends AbstractProfile {
    private static final short INDEX_NULL_COUNT = 0;
    private static final short INDEX_EMPTY_COUNT = 1;
    private static final short INDEX_HIGHEST_VALUE = 2;
    private static final short INDEX_LOWEST_VALUE = 3;
    private Map<Column, Object[]> _counts = new HashMap<Column, Object[]>();

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        Object[] counters = this._counts.get(column);
        if (counters == null) {
            counters = new Object[]{0L, 0L, null, null};
            this._counts.put(column, counters);
        }
        if (value == null) {
            counters[0] = (Long)counters[0] + valueCount;
        } else {
            this.checkHighestValue(value, counters);
            this.checkLowestValue(value, counters);
            if ("".equals(value.toString().trim())) {
                counters[1] = (Long)counters[1] + valueCount;
            }
        }
    }

    private void checkLowestValue(Object value, Object[] counters) {
        if (value != null) {
            Object lowestValueBefore = counters[3];
            if (lowestValueBefore != null) {
                Object highestValue = StandardMeasuresProfile.getHighestObject(value, lowestValueBefore);
                if (highestValue == lowestValueBefore) {
                    counters[3] = value;
                }
            } else {
                counters[3] = value;
            }
        }
    }

    private void checkHighestValue(Object value, Object[] counters) {
        Object highestValueBefore = counters[2];
        Object highestValue = StandardMeasuresProfile.getHighestObject(value, highestValueBefore);
        if (highestValue == value) {
            counters[2] = value;
        }
    }

    public static Object getHighestObject(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return null;
        }
        int compareResult = ObjectComparator.getComparator().compare(obj1, obj2);
        if (compareResult > 0) {
            return obj1;
        }
        return obj2;
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        MatrixBuilder mb = new MatrixBuilder();
        mb.addRow("Row count", new Object[0]);
        mb.addRow("Null values", new Object[0]);
        mb.addRow("Empty values", new Object[0]);
        mb.addRow("Highest value", new Object[0]);
        mb.addRow("Lowest value", new Object[0]);
        for (int i = 0; i < this._columns.length; ++i) {
            Column column = this._columns[i];
            String columnName = column.getName();
            Object[] counts = this._counts.get(column);
            Object nullCount = counts[0];
            Object emptyCount = counts[1];
            Object highestValue = counts[2];
            Object lowestValue = counts[3];
            MatrixValue[] values = mb.addColumn(columnName, this._totalCount, nullCount, emptyCount, highestValue, lowestValue);
            if ((Long)nullCount > 0L) {
                values[1].setDetailSource(new Query().from(column.getTable()).select(this._columns).where(new FilterItem[]{new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, null)}));
            }
            if ((Long)emptyCount <= 0L || column.getType() != null && !column.getType().isLiteral()) continue;
            values[2].setDetailSource(new Query().from(column.getTable()).select(this._columns).where(new FilterItem[]{new FilterItem(new SelectItem(column), OperatorType.EQUALS_TO, (Object)"")}));
        }
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        if (!mb.isEmpty()) {
            result.add(mb.getMatrix());
        }
        return result;
    }
}

