/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.IRowFilter;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringAnalysisProfile
extends AbstractProfile {
    private static final short INDEX_NUM_CHARS = 0;
    private static final short INDEX_MAX_CHARS = 1;
    private static final short INDEX_MIN_CHARS = 2;
    private static final short INDEX_NUM_UPPERCASE = 3;
    private static final short INDEX_NUM_LOWERCASE = 4;
    private static final short INDEX_NUM_NONLETTER = 5;
    private static final short INDEX_NUM_WORDS = 6;
    private static final short INDEX_MAX_WORDS = 7;
    private static final short INDEX_MIN_WORDS = 8;
    private Map<Column, Long[]> _counts = new HashMap<Column, Long[]>();

    @Override
    public void initialize(Column ... columns) {
        super.initialize(columns);
        for (Column column : columns) {
            if (column.getType().isLiteral()) continue;
            IllegalArgumentException e = new IllegalArgumentException("Column is not of literal type: " + column);
            this._log.error((Object)e);
            throw e;
        }
    }

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        Long[] counters = this._counts.get(column);
        if (counters == null) {
            counters = new Long[9];
            counters[2] = null;
            counters[1] = null;
            counters[0] = 0L;
            counters[3] = 0L;
            counters[4] = 0L;
            counters[5] = 0L;
            counters[6] = 0L;
            counters[8] = null;
            counters[7] = null;
            this._counts.put(column, counters);
        }
        if (value != null) {
            String string = value.toString();
            long length = string.length();
            long numWords = new StringTokenizer(string).countTokens();
            if (counters[2] == null) {
                counters[1] = length;
                counters[2] = length;
                counters[8] = numWords;
                counters[7] = numWords;
            }
            counters[0] = counters[0] + length;
            counters[6] = counters[6] + numWords;
            if (counters[1] < length) {
                counters[1] = length;
            }
            if (counters[2] > length) {
                counters[2] = length;
            }
            if (counters[7] < numWords) {
                counters[7] = numWords;
            }
            if (counters[8] > numWords) {
                counters[8] = numWords;
            }
            int i = 0;
            while ((long)i < length) {
                char c = string.charAt(i);
                if (Character.isLetter(c)) {
                    if (Character.isUpperCase(c)) {
                        counters[3] = counters[3] + 1L;
                    } else {
                        counters[4] = counters[4] + 1L;
                    }
                } else {
                    counters[5] = counters[5] + 1L;
                }
                ++i;
            }
        }
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        MatrixBuilder mb = new MatrixBuilder();
        mb.addRow("Char count", new Object[0]);
        mb.addRow("Max chars", new Object[0]);
        mb.addRow("Min chars", new Object[0]);
        mb.addRow("Uppercase chars", new Object[0]);
        mb.addRow("Lowercase chars", new Object[0]);
        mb.addRow("Non-letter chars", new Object[0]);
        mb.addRow("Word count", new Object[0]);
        mb.addRow("Max words", new Object[0]);
        mb.addRow("Min words", new Object[0]);
        for (int i = 0; i < this._columns.length; ++i) {
            MatrixValue mv;
            Column column = this._columns[i];
            String columnName = column.getName();
            Long[] counts = this._counts.get(column);
            Long numChars = counts[0];
            Long maxChars = counts[1];
            Long minChars = counts[2];
            String numUppercase = "0%";
            String numLowercase = "0%";
            String numNonletter = "0%";
            if (numChars > 0L) {
                numUppercase = counts[3] * 100L / numChars + "%";
                numLowercase = counts[4] * 100L / numChars + "%";
                numNonletter = counts[5] * 100L / numChars + "%";
            }
            Long numWords = counts[6];
            Long maxWords = counts[7];
            Long minWords = counts[8];
            MatrixValue[] matrixValues = mb.addColumn(columnName, numChars, maxChars, minChars, numUppercase, numLowercase, numNonletter, numWords, maxWords, minWords);
            if (maxChars != null) {
                mv = matrixValues[1];
                mv.setDetailSource(this.getBaseQuery(column));
                mv.addDetailRowFilter(this.getCharFilter(column, maxChars));
            }
            if (minChars != null) {
                mv = matrixValues[2];
                mv.setDetailSource(this.getBaseQuery(column));
                mv.addDetailRowFilter(this.getCharFilter(column, minChars));
            }
            if (maxWords != null) {
                mv = matrixValues[7];
                mv.setDetailSource(this.getBaseQuery(column));
                mv.addDetailRowFilter(this.getWordFilter(column, maxWords));
            }
            if (minWords == null) continue;
            mv = matrixValues[8];
            mv.setDetailSource(this.getBaseQuery(column));
            mv.addDetailRowFilter(this.getWordFilter(column, minWords));
        }
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        if (!mb.isEmpty()) {
            result.add(mb.getMatrix());
        }
        return result;
    }

    private IRowFilter getCharFilter(final Column column, final Long numChars) {
        return new IRowFilter(){

            public boolean accept(Row row) {
                Object value = row.getValue(column);
                return value != null && (long)value.toString().length() == numChars;
            }
        };
    }

    private IRowFilter getWordFilter(final Column column, final Long numWords) {
        return new IRowFilter(){

            public boolean accept(Row row) {
                Object value = row.getValue(column);
                return value != null && (long)new StringTokenizer(value.toString()).countTokens() == numWords;
            }
        };
    }
}

