/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.IRowFilter;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeAnalysisProfile
extends AbstractProfile {
    private static final DateTimeFormatter DATE_AND_TIME_PATTERN = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter TIME_ONLY_PATTERN = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static final DateTimeFormatter DATE_ONLY_PATTERN = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private Map<Column, SortedMap<DateTime, Long>> _sortedMaps = new HashMap<Column, SortedMap<DateTime, Long>>();
    private Map<Column, Boolean> _isDateOnly = new HashMap<Column, Boolean>();
    private SortedSet<Integer> _years = new TreeSet<Integer>();

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        SortedMap<DateTime, Long> sortedMap = this._sortedMaps.get(column);
        if (sortedMap == null) {
            sortedMap = new TreeMap<DateTime, Long>();
            this._sortedMaps.put(column, sortedMap);
        }
        DateTime dateTime = new DateTime(value);
        Boolean isDateOnly = this._isDateOnly.get(column);
        if (isDateOnly == null) {
            isDateOnly = Boolean.TRUE;
            this._isDateOnly.put(column, isDateOnly);
        }
        if (isDateOnly == Boolean.TRUE && !LocalTime.MIDNIGHT.equals((Object)dateTime.toLocalTime())) {
            isDateOnly = Boolean.FALSE;
            this._isDateOnly.put(column, isDateOnly);
        }
        this._years.add(dateTime.getYear());
        Long dateTimeCount = (Long)sortedMap.get(dateTime);
        if (dateTimeCount == null) {
            dateTimeCount = 0L;
        }
        dateTimeCount = dateTimeCount + valueCount;
        sortedMap.put(dateTime, dateTimeCount);
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        MatrixBuilder matrixBuilder = new MatrixBuilder();
        matrixBuilder.addRow("Highest value", new Object[0]);
        matrixBuilder.addRow("Lowest value", new Object[0]);
        for (Integer year : this._years) {
            matrixBuilder.addRow("Where [Year=" + year + "]", new Object[0]);
        }
        for (final Column column : this._columns) {
            SortedMap<DateTime, Long> sortedMap = this._sortedMaps.get(column);
            Boolean isDateOnly = this._isDateOnly.get(column);
            String lowestValue = null;
            String highestValue = null;
            if (column.getType() == ColumnType.TIME) {
                lowestValue = sortedMap.firstKey().toString(TIME_ONLY_PATTERN);
                highestValue = sortedMap.lastKey().toString(TIME_ONLY_PATTERN);
            } else if (isDateOnly.booleanValue()) {
                lowestValue = sortedMap.firstKey().toString(DATE_ONLY_PATTERN);
                highestValue = sortedMap.lastKey().toString(DATE_ONLY_PATTERN);
            } else {
                lowestValue = sortedMap.firstKey().toString(DATE_AND_TIME_PATTERN);
                highestValue = sortedMap.lastKey().toString(DATE_AND_TIME_PATTERN);
            }
            int rowCount = matrixBuilder.getRowCount();
            Object[] columnContent = new Object[rowCount];
            columnContent[0] = highestValue;
            columnContent[1] = lowestValue;
            Integer[] yearArray = this._years.toArray(new Integer[this._years.size()]);
            for (int i = 0; i < yearArray.length; ++i) {
                int yearCount = 0;
                DateTime from = new DateTime(yearArray[i].intValue(), 1, 1, 0, 0, 0, 0);
                DateTime to = new DateTime(yearArray[i] + 1, 1, 1, 0, 0, 0, 0);
                SortedMap<DateTime, Long> subMap = sortedMap.subMap(from, to);
                Set<Map.Entry<DateTime, Long>> entrySet = subMap.entrySet();
                for (Map.Entry<DateTime, Long> entry : entrySet) {
                    yearCount = (int)((long)yearCount + entry.getValue());
                }
                columnContent[2 + i] = yearCount;
            }
            MatrixValue[] matrixValues = matrixBuilder.addColumn(column.getName(), columnContent);
            for (int i = 0; i < yearArray.length; ++i) {
                final int year = yearArray[i];
                MatrixValue mv = matrixValues[2 + i];
                if ((Integer)mv.getValue() <= 0) continue;
                Query q = this.getBaseQuery();
                if (column.getType() == ColumnType.DATE || column.getType() == ColumnType.TIMESTAMP) {
                    q.where(column, OperatorType.HIGHER_THAN, (Object)new LocalDate(year - 1, 12, 31).toDateTimeAtStartOfDay());
                    q.where(column, OperatorType.LOWER_THAN, (Object)new LocalDate(year + 1, 1, 1).toDateTimeAtStartOfDay());
                }
                mv.setDetailSource(q);
                mv.addDetailRowFilter(new IRowFilter(){

                    public boolean accept(Row row) {
                        DateTime dateTime;
                        Object value = row.getValue(column);
                        return value != null && (dateTime = new DateTime(value)).getYear() == year;
                    }
                });
            }
        }
        if (!matrixBuilder.isEmpty()) {
            result.add(matrixBuilder.getMatrix());
        }
        return result;
    }
}

