/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.profiler.trivial;

import dk.eobjects.datacleaner.profiler.AbstractProfile;
import dk.eobjects.datacleaner.profiler.IMatrix;
import dk.eobjects.datacleaner.profiler.MatrixBuilder;
import dk.eobjects.datacleaner.profiler.MatrixValue;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.data.IRowFilter;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.query.FilterItem;
import dk.eobjects.metamodel.query.OperatorType;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.query.SelectItem;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.util.ObjectComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueDistributionProfile
extends AbstractProfile {
    public static final String PROPERTY_TOP_N = "Top n most frequent values";
    public static final String PROPERTY_BOTTOM_N = "Bottom n least frequent values";
    private static final String UNIQUE_VALUES_LABEL = "<Unique values>";
    private Map<Column, Map<String, Long>> _repeatedValues = new HashMap<Column, Map<String, Long>>();
    private Integer _topCount;
    private Integer _bottomCount;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._topCount = this.getPropertyInteger(PROPERTY_TOP_N);
        this._bottomCount = this.getPropertyInteger(PROPERTY_BOTTOM_N);
    }

    @Override
    protected void processValue(Column column, Object value, long valueCount, Row row) {
        Long repeatCount;
        Map<String, Long> valueMap;
        String repeatedValue = null;
        if (value != null) {
            repeatedValue = value.toString();
        }
        if ((valueMap = this._repeatedValues.get(column)) == null) {
            valueMap = new HashMap<String, Long>();
            this._repeatedValues.put(column, valueMap);
        }
        if ((repeatCount = valueMap.get(repeatedValue)) == null) {
            repeatCount = 0L;
        }
        repeatCount = repeatCount + valueCount;
        valueMap.put(repeatedValue, repeatCount);
    }

    @Override
    protected List<IMatrix> getResultMatrices() {
        List<IMatrix> result = this._topCount == null || this._bottomCount == null ? this.generateResultForEachColumn() : this.generateCollectiveResult(this._topCount, this._bottomCount);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private List<IMatrix> generateCollectiveResult(int topCount, int bottomCount) {
        int i;
        MatrixBuilder mb = new MatrixBuilder();
        if (topCount <= 0) {
            this._log.warn((Object)"The top property was zero or negative! Resetting to 5.");
            topCount = 5;
        }
        if (bottomCount <= 0) {
            this._log.warn((Object)"The bottom property was zero or negative! Resetting to 5.");
            bottomCount = 5;
        }
        for (i = 0; i < topCount; ++i) {
            mb.addRow("top " + (i + 1), new Object[0]);
        }
        for (i = bottomCount; i > 0; --i) {
            mb.addRow("bottom " + i, new Object[0]);
        }
        for (Column column : this._columns) {
            void var18_27;
            void var18_25;
            boolean hasUniqueValues;
            String columnName = column.getName();
            Object[] rowValues = new Object[topCount + bottomCount];
            Set<Map.Entry<String, Long>> entries = this._repeatedValues.get(column).entrySet();
            ArrayList<Object[]> uniqueValues = new ArrayList<Object[]>();
            ArrayList<Map.Entry<String, Long>> sortedEntries = new ArrayList<Map.Entry<String, Long>>(entries);
            Iterator it = sortedEntries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if ((Long)entry.getValue() != 1L) continue;
                uniqueValues.add(new Object[]{entry.getKey()});
                it.remove();
            }
            Collections.sort(sortedEntries, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    Long o1count = o1.getValue();
                    Long o2count = o2.getValue();
                    int compareTo = o2count.compareTo(o1count);
                    if (compareTo == 0) {
                        compareTo = ObjectComparator.getComparator().compare(o1.getKey(), o2.getKey());
                    }
                    return compareTo;
                }
            });
            int registeredEntries = 0;
            ArrayList<Map.Entry> topValues = new ArrayList<Map.Entry>();
            Iterator it2 = sortedEntries.iterator();
            while (it2.hasNext()) {
                Map.Entry entry = (Map.Entry)it2.next();
                topValues.add(entry);
                it2.remove();
                if (++registeredEntries != topCount) continue;
                break;
            }
            registeredEntries = 0;
            Collections.reverse(sortedEntries);
            ArrayList<Map.Entry> bottomValues = new ArrayList<Map.Entry>();
            boolean bl = hasUniqueValues = !uniqueValues.isEmpty();
            if (hasUniqueValues) {
                rowValues[topCount + bottomCount - 1] = "<Unique values> (" + uniqueValues.size() + ")";
                ++registeredEntries;
            }
            for (Map.Entry entry : sortedEntries) {
                bottomValues.add(entry);
                if (++registeredEntries != bottomCount) continue;
                break;
            }
            sortedEntries = null;
            String[] detailOperands = new String[topCount + bottomCount];
            boolean bl2 = false;
            while (var18_25 < topCount) {
                if (topValues.size() > var18_25) {
                    Map.Entry topEntry = (Map.Entry)topValues.get((int)var18_25);
                    String key = (String)topEntry.getKey();
                    rowValues[var18_25] = key == null ? "<null> (" + topEntry.getValue() + ")" : key + " (" + topEntry.getValue() + ")";
                    detailOperands[var18_25] = key;
                }
                ++var18_25;
            }
            boolean bl3 = false;
            while (var18_27 < bottomCount) {
                if (bottomValues.size() > var18_27) {
                    Map.Entry bottomEntry = (Map.Entry)bottomValues.get((int)var18_27);
                    int bottomIndex = topCount + bottomCount - 1 - var18_27;
                    if (hasUniqueValues) {
                        --bottomIndex;
                    }
                    if (rowValues.length > bottomIndex) {
                        String key = (String)bottomEntry.getKey();
                        rowValues[bottomIndex] = key == null ? "<null> (" + bottomEntry.getValue() + ")" : key + " (" + bottomEntry.getValue() + ")";
                        detailOperands[bottomIndex] = key;
                    }
                }
                ++var18_27;
            }
            MatrixValue[] matrixValueArray = mb.addColumn(columnName, rowValues);
            for (int i3 = 0; i3 < matrixValueArray.length; ++i3) {
                MatrixValue matrixValue = matrixValueArray[i3];
                if (matrixValue.getValue() == null) continue;
                this.generateDetailSources(matrixValue, column, detailOperands[i3]);
            }
            if (!hasUniqueValues) continue;
            Query q = this.getBaseQuery(column).having(new FilterItem[]{new FilterItem(SelectItem.getCountAllItem(), OperatorType.EQUALS_TO, (Object)1)});
            matrixValueArray[matrixValueArray.length - 1].setDetailSource(q);
        }
        ArrayList<IMatrix> result = new ArrayList<IMatrix>(1);
        result.add(mb.getMatrix());
        return result;
    }

    private void generateDetailSources(MatrixValue matrixValue, final Column column, final String value) {
        Query query = this.getBaseQuery();
        if (value != null && value.indexOf(39) != -1) {
            String wildcardValue = value.replace('\'', '%');
            query.where(column, OperatorType.LIKE, (Object)wildcardValue);
            matrixValue.addDetailRowFilter(new IRowFilter(){

                public boolean accept(Row row) {
                    return value.equals(row.getValue(column));
                }
            });
        } else {
            query.where(column, OperatorType.EQUALS_TO, (Object)value);
        }
        matrixValue.setDetailSource(query);
    }

    private List<IMatrix> generateResultForEachColumn() {
        ArrayList<IMatrix> result = new ArrayList<IMatrix>();
        for (int i = 0; i < this._columns.length; ++i) {
            int uniqueCount;
            Column column = this._columns[i];
            String columnName = column.getName();
            Map<String, Long> valueMap = this._repeatedValues.get(column);
            MatrixBuilder mb = new MatrixBuilder();
            mb.addColumn(columnName + " frequency", new Object[0]);
            mb.addColumn("Percentage of total", new Object[0]);
            ArrayList<Object[]> uniqueValues = new ArrayList<Object[]>();
            for (Map.Entry<String, Long> entry : valueMap.entrySet()) {
                Long repeatCount = entry.getValue();
                String value = entry.getKey();
                if (repeatCount == 1L) {
                    uniqueValues.add(new Object[]{value});
                    continue;
                }
                int repeatPercentage = (int)(repeatCount * 100L / this._totalCount);
                MatrixValue[] matrixValues = mb.addRow(value, repeatCount, repeatPercentage + "%");
                this.generateDetailSources(matrixValues[0], column, value);
            }
            if (!mb.isEmpty()) {
                mb.sortColumn(0, (short)1);
            }
            if ((uniqueCount = uniqueValues.size()) > 0) {
                int otherPercentage = (int)((long)(uniqueCount * 100) / this._totalCount);
                MatrixValue[] matrixValues = mb.addRow(UNIQUE_VALUES_LABEL, uniqueCount, otherPercentage + "%");
                matrixValues[0].setDetailSource(new DataSet(new SelectItem[]{new SelectItem(UNIQUE_VALUES_LABEL, null)}, uniqueValues));
            }
            result.add(mb.getMatrix());
        }
        return result;
    }
}

