/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.util;

import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Schema;
import dk.eobjects.metamodel.schema.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomHelper {
    public static List<Node> getChildNodesByName(Node parentNode, String childNodeName) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (childNodeName != null) {
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (!childNodeName.equals(childNode.getNodeName())) continue;
                result.add(childNode);
            }
        }
        return result;
    }

    public static String getAttributeValue(Node node, String attributeName) {
        Attr attr = (Attr)node.getAttributes().getNamedItem(attributeName);
        return attr.getValue();
    }

    public static void addColumnNodes(Document doc, Node superNode, Column[] columns) {
        for (Column column : columns) {
            Schema schema;
            Element columnElement = doc.createElement("column");
            columnElement.setTextContent(column.getName());
            Table table = column.getTable();
            if (table != null && table.getName() != null) {
                columnElement.setAttribute("table", table.getName());
            }
            if ((schema = table.getSchema()) != null && schema.getName() != null) {
                columnElement.setAttribute("schema", schema.getName());
            }
            superNode.appendChild(columnElement);
        }
    }

    public static void addPropertyNodes(Document doc, Node superNode, Map<String, String> properties) {
        ArrayList<Map.Entry<String, String>> entryList = new ArrayList<Map.Entry<String, String>>(properties.entrySet());
        Comparator<Map.Entry<String, String>> comparator = new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String key1 = o1.getKey();
                if (key1 != null) {
                    return key1.compareTo(o2.getKey());
                }
                return -1;
            }
        };
        Collections.sort(entryList, comparator);
        for (Map.Entry<String, String> entry : entryList) {
            Element propertyElement = doc.createElement("property");
            propertyElement.setAttribute("name", entry.getKey());
            propertyElement.setTextContent(entry.getValue());
            superNode.appendChild(propertyElement);
        }
    }

    public static Map<String, String> getPropertiesFromChildNodes(Node node) {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<Node> propertyNodes = DomHelper.getChildNodesByName(node, "property");
        for (Node propertyNode : propertyNodes) {
            String propertyName = DomHelper.getAttributeValue(propertyNode, "name");
            String propertyValue = propertyNode.getTextContent();
            if (propertyValue != null) {
                propertyValue = propertyValue.trim();
            }
            properties.put(propertyName, propertyValue);
        }
        return properties;
    }

    public static List<Column> getColumnsFromChildNodes(Node node, DataContext dataContext) {
        List<Node> columnNodes = DomHelper.getChildNodesByName(node, "column");
        ArrayList<Column> columns = new ArrayList<Column>(columnNodes.size());
        for (Node columnNode : columnNodes) {
            String schemaName = DomHelper.getAttributeValue(columnNode, "schema");
            String tableName = DomHelper.getAttributeValue(columnNode, "table");
            String columnName = columnNode.getTextContent();
            if (columnName != null) {
                columnName = columnName.trim();
            }
            try {
                Schema schema = dataContext.getSchemaByName(schemaName);
                Table table = schema.getTableByName(tableName);
                Column column = table.getColumnByName(columnName);
                columns.add(column);
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Could not resolve column '" + columnName + "'", e);
            }
        }
        return columns;
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void transform(Node node, Result result) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer trans = tf.newTransformer();
            trans.transform(new DOMSource(node), result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

