/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionHelper {
    public static Object[] getProperties(Object[] objects, String propertyName) {
        Object[] result = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = ReflectionHelper.getProperty(objects[i], propertyName);
        }
        return result;
    }

    public static Object[] getProperties(Collection<? extends Object> objects, String string) {
        return ReflectionHelper.getProperties(objects.toArray(new Object[objects.size()]), string);
    }

    public static Object getProperty(Object object, String propertyName) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getField(propertyName);
            return field.get(object);
        }
        catch (Exception e) {
            try {
                StringBuilder sb = new StringBuilder(propertyName);
                sb.replace(0, 1, "" + Character.toUpperCase(propertyName.charAt(0)));
                Method method = clazz.getMethod("get" + sb.toString(), new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    public static Field[] getConstants(Class<? extends Object> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mod = field.getModifiers();
            if (!Modifier.isFinal(mod) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            result.add(field);
        }
        return result.toArray(new Field[result.size()]);
    }

    public static List<String> getIteratedProperties(String prefix, Map<String, String> properties) {
        ArrayList<String> result = new ArrayList<String>();
        if (properties != null) {
            String value;
            int i = 0;
            while ((value = properties.get(prefix + i)) != null) {
                result.add(value);
                ++i;
            }
        }
        return result;
    }

    public static void addIteratedProperties(Map<String, String> properties, String prefix, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            properties.put(prefix + i, values[i]);
        }
    }
}

