/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.util;

import dk.eobjects.datacleaner.util.WeakObserver;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeakObservable {
    protected final transient Log _log = LogFactory.getLog(this.getClass());
    private transient List<WeakReference<WeakObserver>> _observers = new LinkedList<WeakReference<WeakObserver>>();
    private transient boolean _changed = false;

    public int getObserverCount() {
        Iterator<WeakReference<WeakObserver>> it = this._observers.iterator();
        while (it.hasNext()) {
            WeakReference<WeakObserver> observerRef = it.next();
            WeakObserver weakObserver = (WeakObserver)observerRef.get();
            if (weakObserver != null) continue;
            it.remove();
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("Removed weak observer: " + observerRef));
        }
        return this._observers.size();
    }

    public void addObserver(WeakObserver observer) {
        this._observers.add(new WeakReference<WeakObserver>(observer));
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Added weak observer: " + observer));
            this._log.debug((Object)("Number of weak observers: " + this._observers.size()));
        }
    }

    public void deleteObserver(WeakObserver observer) {
        Iterator<WeakReference<WeakObserver>> it = this._observers.iterator();
        while (it.hasNext()) {
            WeakReference<WeakObserver> observerRef = it.next();
            WeakObserver weakObserver = (WeakObserver)observerRef.get();
            if (weakObserver != null && weakObserver != observer) continue;
            it.remove();
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("Removed weak observer: " + observerRef));
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Number of weak observers: " + this._observers.size()));
        }
    }

    public void setChanged() {
        this._changed = true;
    }

    public void notifyObservers() {
        if (this._changed) {
            Iterator<WeakReference<WeakObserver>> it = this._observers.iterator();
            while (it.hasNext()) {
                WeakReference<WeakObserver> observerRef = it.next();
                WeakObserver weakObserver = (WeakObserver)observerRef.get();
                if (weakObserver == null) {
                    it.remove();
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)("Removed weak observer: " + observerRef));
                    continue;
                }
                weakObserver.update(this);
            }
            this._changed = false;
        }
    }
}

