/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator;

import dk.eobjects.datacleaner.execution.IRunnableConfiguration;
import dk.eobjects.datacleaner.util.DomHelper;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import dk.eobjects.datacleaner.validator.ValidatorManager;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleConfiguration
implements IRunnableConfiguration {
    public static final String NODE_NAME = "configuration";
    private static final long serialVersionUID = -3666518358685662574L;
    private IValidationRuleDescriptor _validationRuleDescriptor;
    private Map<String, String> _validationRuleProperties = new HashMap<String, String>();
    private Column[] _columns;

    public ValidationRuleConfiguration() {
    }

    public ValidationRuleConfiguration(IValidationRuleDescriptor descriptor) {
        this();
        this.setValidationRuleDescriptor(descriptor);
    }

    public void addValidationRuleProperty(String property, String value) {
        this._validationRuleProperties.put(property, value);
    }

    public IValidationRuleDescriptor getValidationRuleDescriptor() {
        return this._validationRuleDescriptor;
    }

    public void setValidationRuleDescriptor(IValidationRuleDescriptor validationRuleDescriptor) {
        this._validationRuleDescriptor = validationRuleDescriptor;
    }

    public Map<String, String> getValidationRuleProperties() {
        return this._validationRuleProperties;
    }

    public void setValidationRuleProperties(Map<String, String> validationRuleProperties) {
        this._validationRuleProperties = validationRuleProperties;
    }

    @Override
    public Column[] getColumns() {
        if (this._columns == null) {
            return new Column[0];
        }
        return this._columns;
    }

    public void setColumns(Column ... columns) {
        this._columns = columns;
    }

    public String toString() {
        return "ValidationRuleConfiguration[validationRuleDescriptor=" + this._validationRuleDescriptor + ",columns=" + ArrayUtils.toString((Object)this._columns) + ",properties=" + this._validationRuleProperties.toString() + "]";
    }

    public void setColumns(List<Column> columns) {
        this.setColumns(columns.toArray(new Column[columns.size()]));
    }

    public static ValidationRuleConfiguration deserialize(Node node, DataContext dc) throws IllegalArgumentException {
        if (!NODE_NAME.equals(node.getNodeName())) {
            throw new IllegalArgumentException("Node name must be 'configuration', found '" + node.getNodeName() + "'");
        }
        String validationRuleClassName = DomHelper.getAttributeValue(node, "validationRuleClass");
        IValidationRuleDescriptor validationRuleDescriptor = ValidatorManager.getValidationRuleDescriptorByValidationRuleClassName(validationRuleClassName);
        if (validationRuleDescriptor == null) {
            throw new IllegalArgumentException("Could not resolve validationRuleClass '" + validationRuleClassName + "'");
        }
        ValidationRuleConfiguration configuration = new ValidationRuleConfiguration(validationRuleDescriptor);
        Map<String, String> properties = DomHelper.getPropertiesFromChildNodes(node);
        configuration.setValidationRuleProperties(properties);
        List<Column> columns = DomHelper.getColumnsFromChildNodes(node, dc);
        configuration.setColumns(columns);
        return configuration;
    }

    public Element serialize(Document document) {
        Element configurationElement = document.createElement(NODE_NAME);
        String profileClass = this.getValidationRuleDescriptor().getValidationRuleClass().getName();
        configurationElement.setAttribute("validationRuleClass", profileClass);
        Map<String, String> properties = this.getValidationRuleProperties();
        DomHelper.addPropertyNodes(document, configurationElement, properties);
        Column[] columns = this.getColumns();
        DomHelper.addColumnNodes(document, configurationElement, columns);
        return configurationElement;
    }
}

