/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator;

import dk.eobjects.datacleaner.validator.IValidationRule;
import dk.eobjects.datacleaner.validator.IValidationRuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorManager {
    private static List<IValidationRuleDescriptor> _validationRuleDescriptors = new ArrayList<IValidationRuleDescriptor>();
    private static Log _log = LogFactory.getLog(ValidatorManager.class);

    private ValidatorManager() {
    }

    public static IValidationRuleDescriptor[] getValidationRuleDescriptors() {
        return _validationRuleDescriptors.toArray(new IValidationRuleDescriptor[_validationRuleDescriptors.size()]);
    }

    public static IValidationRuleDescriptor getValidationRuleDescriptorByValidationRuleClass(Class<? extends IValidationRule> validationRuleClass) {
        if (validationRuleClass != null) {
            for (IValidationRuleDescriptor descriptor : _validationRuleDescriptors) {
                if (validationRuleClass != descriptor.getValidationRuleClass()) continue;
                return descriptor;
            }
        }
        return null;
    }

    public static IValidationRuleDescriptor getValidationRuleDescriptorByValidationRuleClassName(String validationRuleClassName) {
        if (validationRuleClassName != null) {
            for (IValidationRuleDescriptor descriptor : _validationRuleDescriptors) {
                if (!validationRuleClassName.equals(descriptor.getValidationRuleClass().getName())) continue;
                return descriptor;
            }
        }
        return null;
    }

    public static void setValidationRuleDescriptors(List<IValidationRuleDescriptor> validationRuleDescriptors) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting profile descriptors: " + ArrayUtils.toString(validationRuleDescriptors)));
        }
        _validationRuleDescriptors = validationRuleDescriptors;
    }

    public static void addValidationRuleDescriptor(IValidationRuleDescriptor descriptor) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding profile descriptor: " + descriptor));
        }
        _validationRuleDescriptors.add(descriptor);
    }
}

