/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator.condition;

import dk.eobjects.datacleaner.validator.AbstractValidationRule;
import dk.eobjects.datacleaner.validator.IValidationRuleResult;
import dk.eobjects.datacleaner.validator.condition.ScriptAccessColumnMap;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptValidationRule
extends AbstractValidationRule {
    public static final String PROPERTY_JAVASCRIPT_EXPRESSION = "Javascript expression";
    private Set<Column> _evaluatedColumns = new HashSet<Column>();
    private Context _context;
    private Script _script;
    private ScriptableObject _standardObjectsScope;

    public void initialize(Column ... columns) {
        super.initialize(columns);
        String expression = (String)this._properties.get(PROPERTY_JAVASCRIPT_EXPRESSION);
        if (expression == null) {
            throw new IllegalStateException("No javascript expression provided!");
        }
        this._context = ContextFactory.getGlobal().enterContext();
        this._script = this._context.compileString(expression, "JavascriptValidationRule", 1, null);
        this._standardObjectsScope = this._context.initStandardObjects();
    }

    protected boolean isValid(Row row) throws Exception {
        ScriptAccessColumnMap values = new ScriptAccessColumnMap(this._columns, row, this._evaluatedColumns);
        Scriptable scope = this._context.newObject((Scriptable)this._standardObjectsScope);
        scope.setPrototype((Scriptable)this._standardObjectsScope);
        scope.setParentScope(null);
        Object wrappedValues = Context.javaToJS((Object)values, (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"values", (Object)wrappedValues);
        Object result = this._script.exec(this._context, scope);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new IllegalStateException("Javascript expression did not return a boolean");
    }

    public IValidationRuleResult getResult() {
        Context.exit();
        this.setEvaluatedColumns(this._evaluatedColumns.toArray(new Column[this._evaluatedColumns.size()]));
        return super.getResult();
    }
}

