/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator.dictionary;

import dk.eobjects.datacleaner.catalog.IDictionary;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryManager {
    private static final Log _log = LogFactory.getLog(DictionaryManager.class);
    private static List<IDictionary> _dictionaries = new ArrayList<IDictionary>();

    public static void setDictionaries(List<IDictionary> dictionaries) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Setting dictionaries: " + ArrayUtils.toString(dictionaries)));
        }
        _dictionaries = dictionaries;
    }

    public static IDictionary[] getDictionaries() {
        return _dictionaries.toArray(new IDictionary[_dictionaries.size()]);
    }

    public static IDictionary getDictionaryByName(String name) {
        if (name != null) {
            for (IDictionary dictionary : _dictionaries) {
                String dictionaryName;
                if (dictionary == null || !name.equals(dictionaryName = dictionary.getName())) continue;
                return dictionary;
            }
        }
        return null;
    }

    public static void addDictionary(IDictionary dictionary) {
        _dictionaries.add(dictionary);
    }
}

