/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator.dictionary;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.validator.IValidationRule;
import dk.eobjects.datacleaner.validator.IValidationRuleResult;
import dk.eobjects.datacleaner.validator.SimpleValidationRuleResult;
import dk.eobjects.datacleaner.validator.ValidatorManager;
import dk.eobjects.datacleaner.validator.dictionary.DictionaryManager;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryValidationRule
implements IValidationRule {
    public static final String PROPERTY_BUFFER_SIZE = "Buffer size";
    public static final String PROPERTY_DICTIONARY_NAME = "Dictionary name";
    private static Log _log = LogFactory.getLog(DictionaryValidationRule.class);
    private IDictionary _dictionary;
    private int _queryBufferSize = 50;
    private Column[] _columns;
    private List<Row> _bufferValues = new ArrayList<Row>();
    private SimpleValidationRuleResult _result;
    private Map<String, String> _properties;

    public void setDictionary(IDictionary dictionary) {
        this._dictionary = dictionary;
    }

    public void setQueryBufferSize(int i) {
        this._queryBufferSize = i;
    }

    @Override
    public IValidationRuleResult getResult() {
        this.checkValues();
        return this._result;
    }

    @Override
    public void initialize(Column ... columns) {
        if (this._properties != null) {
            String bufferSizeStr = this._properties.get(PROPERTY_BUFFER_SIZE);
            if (bufferSizeStr != null) {
                try {
                    this._queryBufferSize = Integer.parseInt(bufferSizeStr);
                }
                catch (NumberFormatException e) {
                    _log.info((Object)e);
                }
            }
            if (this._dictionary == null) {
                String dictionaryName = this._properties.get(PROPERTY_DICTIONARY_NAME);
                this._dictionary = DictionaryManager.getDictionaryByName(dictionaryName);
            }
        }
        this._columns = columns;
        this._result = new SimpleValidationRuleResult(columns, ValidatorManager.getValidationRuleDescriptorByValidationRuleClass(DictionaryValidationRule.class), this._properties);
    }

    @Override
    public void process(Row row, long distinctRowCount) {
        if (this._dictionary == null) {
            throw new IllegalStateException("No dictionary provided!");
        }
        this._bufferValues.add(row);
        int numValues = this._columns.length * this._bufferValues.size();
        if (numValues >= this._queryBufferSize) {
            this.checkValues();
        }
    }

    private void checkValues() {
        int numValues = this._columns.length * this._bufferValues.size();
        String[] queryValues = new String[numValues];
        for (int i = 0; i < this._bufferValues.size(); ++i) {
            Row row = this._bufferValues.get(i);
            for (int j = 0; j < this._columns.length; ++j) {
                Object value = row.getValue(this._columns[j]);
                String queryValue = null;
                if (value != null) {
                    queryValue = value.toString();
                }
                queryValues[i * this._columns.length + j] = queryValue;
            }
        }
        boolean[] results = this._dictionary.isValid(queryValues);
        block2: for (int i = 0; i < this._bufferValues.size(); ++i) {
            Row row = this._bufferValues.get(i);
            for (int j = 0; j < this._columns.length; ++j) {
                if (results[i * this._columns.length + j]) continue;
                this._result.addErrorRow(row);
                continue block2;
            }
        }
        this._bufferValues.clear();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this._properties = properties;
    }

    public IDictionary getDictionary() {
        return this._dictionary;
    }

    public int getQueryBufferSize() {
        return this._queryBufferSize;
    }
}

