/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator.trivial;

import dk.eobjects.datacleaner.validator.AbstractValidationRule;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexValidationRule
extends AbstractValidationRule {
    public static final String PROPERTY_REGEX = "Regular expression";
    private Pattern _pattern;
    private String _expression;

    @Override
    public void setProperties(Map<String, String> properties) {
        super.setProperties(properties);
        this._expression = properties.get(PROPERTY_REGEX);
        if (this._expression == null) {
            throw new IllegalStateException("No regular expression provided");
        }
    }

    @Override
    public void initialize(Column ... columns) {
        super.initialize(columns);
        try {
            this._pattern = Pattern.compile(this._expression);
        }
        catch (PatternSyntaxException e) {
            this._result.setError(e);
        }
    }

    @Override
    protected boolean isValid(Row row) throws Exception {
        int i = 0;
        if (i < this._columns.length) {
            Object value = row.getValue(this._columns[i]);
            if (value != null) {
                Matcher matcher = this._pattern.matcher(value.toString());
                return matcher.matches();
            }
            return false;
        }
        return false;
    }
}

