/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.validator.trivial;

import dk.eobjects.datacleaner.validator.AbstractValidationRule;
import dk.eobjects.metamodel.data.Row;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.ColumnType;
import dk.eobjects.metamodel.util.BooleanComparator;
import dk.eobjects.metamodel.util.NumberComparator;
import dk.eobjects.metamodel.util.ObjectComparator;
import dk.eobjects.metamodel.util.TimeComparator;
import dk.eobjects.metamodel.util.ToStringComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValueRangeValidationRule
extends AbstractValidationRule {
    public static final String PROPERTY_HIGHEST_VALUE = "Highest value";
    public static final String PROPERTY_LOWEST_VALUE = "Lowest value";
    private static final Log _log = LogFactory.getLog(ValueRangeValidationRule.class);
    private Map<Column, Comparable> _highestValues = new HashMap<Column, Comparable>();
    private Map<Column, Comparable> _lowestValues = new HashMap<Column, Comparable>();

    public void initialize(Column ... columns) {
        super.initialize(columns);
        ArrayList<Column> result = new ArrayList<Column>();
        String highestValue = (String)this._properties.get(PROPERTY_HIGHEST_VALUE);
        String lowestValue = (String)this._properties.get(PROPERTY_LOWEST_VALUE);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Highest value: " + highestValue));
            _log.debug((Object)("Lowest value: " + lowestValue));
        }
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            ColumnType type = column.getType();
            try {
                if (highestValue != null) {
                    this._highestValues.put(column, this.getComparable(type, highestValue));
                }
                if (lowestValue != null) {
                    this._lowestValues.put(column, this.getComparable(type, lowestValue));
                }
                result.add(column);
                continue;
            }
            catch (IllegalArgumentException e) {
                _log.error((Object)("Disregarding column because type was incompatible with comparable: " + column));
                _log.info((Object)e);
            }
        }
        this._columns = result.toArray(new Column[result.size()]);
    }

    private Comparable getComparable(ColumnType type, String value) throws IllegalArgumentException {
        try {
            if (type != null) {
                if (type.isLiteral()) {
                    return ToStringComparator.getComparable((Object)value);
                }
                if (type.isNumber()) {
                    return NumberComparator.getComparable((Object)value);
                }
                if (type.isTimeBased()) {
                    return TimeComparator.getComparable((Object)value);
                }
                if (type.isBoolean()) {
                    return BooleanComparator.getComparable((Object)value);
                }
            }
            return ObjectComparator.getComparable((Object)value);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean isValid(Row row) {
        if (this._properties.get(PROPERTY_HIGHEST_VALUE) == null && this._properties.get(PROPERTY_LOWEST_VALUE) == null) {
            throw new IllegalStateException("Neither lowest value or highest value has been set!");
        }
        boolean result = true;
        for (int i = 0; i < this._columns.length && result; ++i) {
            Column column = this._columns[i];
            Object value = row.getValue(column);
            result = this.checkValue(column, value);
        }
        return result;
    }

    private boolean checkValue(Column column, Object value) {
        boolean result = true;
        if (value == null) {
            return false;
        }
        Comparable lowestValue = this._lowestValues.get(column);
        Comparable highestValue = this._highestValues.get(column);
        if (lowestValue != null && lowestValue.compareTo(value) > 0) {
            result = false;
        }
        if (highestValue != null && highestValue.compareTo(value) < 0) {
            result = false;
        }
        return result;
    }

    public Comparable getHighestValue(Column column) {
        return this._highestValues.get(column);
    }

    public Comparable getLowestValue(Column column) {
        return this._lowestValues.get(column);
    }

    public Column[] getColumns() {
        return this._columns;
    }
}

