/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.widgets.DataTable;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.data.DataSet;
import dk.eobjects.metamodel.query.Query;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class CsvConfigurationDialog
extends BanneredDialog
implements ActionListener {
    private static final long serialVersionUID = -8449807287294665745L;
    private static final String CSV_EXTENSION = "csv";
    private static final String COMMA_ACTION_CMD = ",";
    private static final String SEMI_COLON_ACTION_CMD = ";";
    private static final String SINGLE_QUOTE_ACTION_CMD = "'";
    private static final String DOUBLE_QUOTE_ACTION_CMD = "\"";
    private JPanel _dataConfigurationPanel;
    private JTextField _sampleText;
    private DataTable _table;
    private char _curSeparator = (char)44;
    private char _curQuoteChar = (char)34;
    private DataContextSelection _dataContextSelection;
    private File _file;

    public CsvConfigurationDialog(DataContextSelection selection, File file) {
        super(600, 480);
        this._file = file;
        this._dataContextSelection = selection;
        this.updateContent();
        JButton okButton = new JButton("Open", GuiHelper.getImageIcon("images/toolbar_file.png"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CsvConfigurationDialog.this.setVisible(false);
            }
        });
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        toolbar.add(okButton);
        this.add((Component)toolbar, "South");
    }

    protected Component getContent() {
        this._dataConfigurationPanel = new JPanel(null);
        JLabel delimitorLbl = new JLabel("Select the Delimitor:");
        this.addToPanel(delimitorLbl, 10, 5, 200, 20);
        JRadioButton commaButton = new JRadioButton("Use Comma [,]");
        commaButton.setActionCommand(COMMA_ACTION_CMD);
        commaButton.setSelected(true);
        commaButton.addActionListener(this);
        this.addToPanel(commaButton, 10, 35, 150, 20);
        JRadioButton semiColonButton = new JRadioButton("Use Semi Colon [;]");
        semiColonButton.setActionCommand(SEMI_COLON_ACTION_CMD);
        semiColonButton.addActionListener(this);
        this.addToPanel(semiColonButton, 10, 60, 150, 20);
        ButtonGroup delimitorGroup = new ButtonGroup();
        delimitorGroup.add(commaButton);
        delimitorGroup.add(semiColonButton);
        JLabel quotationLbl = new JLabel("Select the Quotation type:");
        this.addToPanel(quotationLbl, 200, 5, 200, 20);
        JRadioButton doubleButton = new JRadioButton("Use Double Quote [\"sample text\"]");
        doubleButton.setActionCommand(DOUBLE_QUOTE_ACTION_CMD);
        doubleButton.setSelected(true);
        doubleButton.addActionListener(this);
        this.addToPanel(doubleButton, 200, 35, 200, 20);
        JRadioButton singleButton = new JRadioButton("Use Single Quote ['sample text']");
        singleButton.setActionCommand(SINGLE_QUOTE_ACTION_CMD);
        singleButton.addActionListener(this);
        this.addToPanel(singleButton, 200, 60, 200, 20);
        ButtonGroup quoteGroup = new ButtonGroup();
        quoteGroup.add(singleButton);
        quoteGroup.add(doubleButton);
        this._sampleText = new JTextField("Sample Text");
        this._sampleText.setText("\"sample text1\", \"sample text2\", ...");
        this._sampleText.setEnabled(false);
        this.addToPanel(this._sampleText, 10, 90, 400, 20);
        JLabel tableHeading = new JLabel("Preview Data:");
        this.addToPanel(tableHeading, 10, 120, 200, 20);
        this._table = new DataTable(new DataSet(new ArrayList(0)));
        this._table.setName("previewTable");
        this.addToPanel(this._table.getTableHeader(), 10, 150, 700, 18);
        this.addToPanel((Component)((Object)this._table), 10, 170, 700, 90);
        return this._dataConfigurationPanel;
    }

    private void addToPanel(Component c, int xPos, int yPos, int width, int height) {
        c.setLocation(xPos, yPos);
        c.setSize(width, height);
        this._dataConfigurationPanel.add(c);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(COMMA_ACTION_CMD) || e.getActionCommand().equals(SEMI_COLON_ACTION_CMD)) {
            this._curSeparator = e.getActionCommand().charAt(0);
        }
        if (e.getActionCommand().equals(SINGLE_QUOTE_ACTION_CMD) || e.getActionCommand().equals(DOUBLE_QUOTE_ACTION_CMD)) {
            this._curQuoteChar = e.getActionCommand().charAt(0);
        }
        this.updateContent();
    }

    private void updateContent() {
        GuiHelper.selectSchemaByFile(this._dataContextSelection, this._file, CSV_EXTENSION, this._curSeparator, this._curQuoteChar);
        this._sampleText.setText(this.buildSampleString(this._curSeparator, this._curQuoteChar));
        DataContext dataContext = this._dataContextSelection.getDataContext();
        Table table = dataContext.getSchemas()[0].getTables()[0];
        Query q = new Query();
        q.from(table).select(table.getColumns());
        q.setMaxRows(Integer.valueOf(5));
        this._table.updateTable(dataContext.executeQuery(q));
    }

    private String buildSampleString(char seperatorChar, char quoteChar) {
        return quoteChar + "sample text 1" + quoteChar + seperatorChar + "423" + seperatorChar + quoteChar + "sample text 2" + quoteChar;
    }

    protected JTextField getSampleText() {
        return this._sampleText;
    }

    protected String getDialogTitle() {
        return "Configure Delimitor and Quotations";
    }
}

