/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.CsvConfigurationDialog;
import dk.eobjects.datacleaner.gui.model.CombinationFilter;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.ExtensionFilter;
import java.io.File;
import javax.swing.JFileChooser;

public class DataFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 3798179789539560724L;
    private DataContextSelection _dataContextSelection;
    public static final String EXTENSION_CSV = "csv";
    public static final String EXTENSION_XLS = "xls";
    private static final String EXTENSION_ODB = "odb";

    public DataFileChooser(DataContextSelection dataContextSelection) {
        this._dataContextSelection = dataContextSelection;
        ExtensionFilter csvFilter = new ExtensionFilter("Comma-separated file (.csv)", EXTENSION_CSV);
        ExtensionFilter excelFilter = new ExtensionFilter("Excel File (.xls)", EXTENSION_XLS);
        ExtensionFilter odbFilter = new ExtensionFilter("OpenOffice.org database (.odb)", EXTENSION_ODB);
        CombinationFilter combinationFilter = new CombinationFilter(csvFilter, excelFilter, odbFilter);
        this.addChoosableFileFilter(combinationFilter);
        this.addChoosableFileFilter(csvFilter);
        this.addChoosableFileFilter(excelFilter);
        this.addChoosableFileFilter(odbFilter);
        this.setFileFilter(combinationFilter);
        this.setAcceptAllFileFilterUsed(false);
        this.setMultiSelectionEnabled(false);
        GuiHelper.centerOnScreen(this);
    }

    public void approveSelection() {
        super.approveSelection();
        File file = this.getSelectedFile();
        if (this.getExtention(file).equalsIgnoreCase(EXTENSION_CSV)) {
            CsvConfigurationDialog dialog = new CsvConfigurationDialog(this._dataContextSelection, file);
            dialog.setVisible(true);
        } else {
            GuiHelper.selectSchemaByFile(this._dataContextSelection, file, this.getExtention(file), new char[0]);
        }
    }

    private String getExtention(File file) {
        if (file != null) {
            String temp = file.getName();
            int i = temp.lastIndexOf(46);
            return temp.substring(i + 1, temp.length());
        }
        return "";
    }
}

