/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.DatabaseDictionary;
import dk.eobjects.datacleaner.gui.model.NamedConnection;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.widgets.SchemaTree;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import dk.eobjects.metamodel.DataContext;
import dk.eobjects.metamodel.schema.Column;
import dk.eobjects.metamodel.schema.Schema;
import dk.eobjects.metamodel.schema.Table;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DatabaseDictionaryDialog
extends BanneredDialog {
    private static final long serialVersionUID = -9126796364763624387L;
    private DatabaseDictionary _dictionary;
    private JComboBox _namedConnectionComboBox;
    private DataContextSelection _dataContextSelection = new DataContextSelection();
    private JTextField _nameField;
    private JButton _saveButton;
    private Schema _schema;
    private Table _table;
    private Column _column;
    private SchemaTree _schemaTree;

    public DatabaseDictionaryDialog(DatabaseDictionary dictionary) {
        super(600, 400);
        this._saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GuiSettings settings = GuiSettings.getSettings();
                String name = DatabaseDictionaryDialog.this._nameField.getText();
                if (name.length() > 2) {
                    String namedConnection = (String)DatabaseDictionaryDialog.this._namedConnectionComboBox.getSelectedItem();
                    String schemaName = DatabaseDictionaryDialog.this._schema.getName();
                    String tableName = DatabaseDictionaryDialog.this._table.getName();
                    String columnName = DatabaseDictionaryDialog.this._column.getName();
                    if (DatabaseDictionaryDialog.this._dictionary == null) {
                        DatabaseDictionaryDialog.this._dictionary = new DatabaseDictionary(name, namedConnection, schemaName, tableName, columnName);
                        settings.getDictionaries().add(DatabaseDictionaryDialog.this._dictionary);
                    } else {
                        DatabaseDictionaryDialog.this._dictionary.setName(name).setNamedConnectionName(namedConnection).setSchemaName(schemaName).setTableName(tableName).setColumnName(columnName);
                    }
                    GuiSettings.saveSettings(settings);
                    DatabaseDictionaryDialog.this.dispose();
                } else {
                    GuiHelper.showErrorMessage("Dictionary name required", "Please provide a name of minimum 3 characters for your dictionary.", new IllegalArgumentException(name));
                }
            }
        });
        this._schemaTree = new SchemaTree(this._dataContextSelection);
        this._schemaTree.setBorder(new MatteBorder(0, 1, 1, 0, Color.BLACK));
        this._schemaTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = DatabaseDictionaryDialog.this._schemaTree.getSelectionPath();
                if (path != null && path.getPathCount() >= 4) {
                    DatabaseDictionaryDialog.this._schema = SchemaTree.getSchema(DatabaseDictionaryDialog.this._dataContextSelection.getDataContext(), path);
                    DatabaseDictionaryDialog.this._table = SchemaTree.getTable(DatabaseDictionaryDialog.this._schema, path);
                    DatabaseDictionaryDialog.this._column = SchemaTree.getColumn(DatabaseDictionaryDialog.this._table, path);
                    if (DatabaseDictionaryDialog.this._column != null) {
                        DatabaseDictionaryDialog.this._saveButton.setEnabled(true);
                    }
                } else {
                    DatabaseDictionaryDialog.this._saveButton.setEnabled(false);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._schemaTree);
        Dimension d = new Dimension();
        d.width = 240;
        scrollPane.setPreferredSize(d);
        scrollPane.setSize(d);
        this.add((Component)scrollPane, "East");
        JTextArea aboutDatabaseDictionaries = new JTextArea();
        aboutDatabaseDictionaries.setEditable(false);
        aboutDatabaseDictionaries.setLineWrap(true);
        aboutDatabaseDictionaries.setWrapStyleWord(true);
        aboutDatabaseDictionaries.setText("Database dictionaries are dictionaries based on columns in databases. To use this kind of dictionary you need to register your database as a named connection in the 'datacleaner-config.xml' file.");
        this.add((Component)aboutDatabaseDictionaries, "South");
        this._dictionary = dictionary;
        this.updateDialog();
    }

    private void updateDialog() {
        if (this._dictionary != null) {
            try {
                this._namedConnectionComboBox.setSelectedItem(this._dictionary.getNamedConnectionName());
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this._schemaTree.getModel().getRoot();
                DefaultMutableTreeNode schemaNode = this.getSubNode(rootNode, this._dictionary.getSchemaName());
                DefaultMutableTreeNode tableNode = this.getSubNode(schemaNode, this._dictionary.getTableName());
                DefaultMutableTreeNode columnNode = this.getSubNode(tableNode, this._dictionary.getColumnName());
                this._schemaTree.setSelectionPath(new TreePath(new Object[]{rootNode, schemaNode, tableNode, columnNode}));
                this._nameField.setText(this._dictionary.getName());
            }
            catch (Exception e) {
                GuiHelper.showErrorMessage("Could not load Database dictionary", "Please verify that the dictionary metadata is correct...\nNamed connection: " + this._dictionary.getNamedConnectionName() + "\nSchema:" + this._dictionary.getSchemaName() + "\nTable: " + this._dictionary.getTableName() + "\nColumn: " + this._dictionary.getColumnName(), e);
                this.dispose();
            }
        }
    }

    private DefaultMutableTreeNode getSubNode(DefaultMutableTreeNode node, String name) {
        if (name == null) {
            name = "(unnamed schema)";
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!name.equals(subNode.getUserObject())) continue;
            return subNode;
        }
        return null;
    }

    protected Component getContent() {
        JPanel panel = new JPanel();
        JLabel header = new JLabel("Database dictionary");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 0, 2, 1);
        GuiHelper.addToGridBag(new JLabel("Dictionary name:"), panel, 0, 1);
        this._nameField = new JTextField();
        GuiHelper.addToGridBag(this._nameField, panel, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Named connection:"), panel, 0, 2);
        Object[] namedConnections = GuiConfiguration.getBeansOfClass(NamedConnection.class).toArray(new NamedConnection[0]);
        Object[] connectionNames = ReflectionHelper.getProperties((Object[])namedConnections, (String)"name");
        this._namedConnectionComboBox = new JComboBox<Object>(connectionNames);
        this._namedConnectionComboBox.addActionListener(new ActionListener((NamedConnection[])namedConnections){
            final /* synthetic */ NamedConnection[] val$namedConnections;
            {
                this.val$namedConnections = namedConnectionArray;
            }

            public void actionPerformed(ActionEvent event) {
                DatabaseDictionaryDialog.this._dataContextSelection.setDataContext(null, null);
                NamedConnection namedConnection = this.val$namedConnections[DatabaseDictionaryDialog.this._namedConnectionComboBox.getSelectedIndex()];
                if (namedConnection.getDriverClass() != null) {
                    try {
                        Connection connection = DriverManager.getConnection(namedConnection.getConnectionString(), namedConnection.getUsername(), namedConnection.getPassword());
                        connection.setReadOnly(true);
                        DatabaseDictionaryDialog.this._dataContextSelection.setDataContext(new DataContext(connection, namedConnection.getCatalog()), connection);
                    }
                    catch (Exception e) {
                        GuiHelper.showErrorMessage("Could not open connection", "An error occurred while trying to open connection to the database.", e);
                    }
                }
            }
        });
        GuiHelper.addToGridBag(this._namedConnectionComboBox, panel, 1, 2);
        this._saveButton = new JButton("Save dictionary", GuiHelper.getImageIcon("images/dictionaries.png"));
        this._saveButton.setEnabled(false);
        GuiHelper.addToGridBag(this._saveButton, panel, 1, 3, 2, 1);
        return panel;
    }

    protected String getDialogTitle() {
        return "Database dictionary";
    }
}

