/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.model.DataContextSelection;
import dk.eobjects.datacleaner.gui.model.DatabaseDriver;
import dk.eobjects.datacleaner.gui.model.NamedConnection;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import dk.eobjects.datacleaner.gui.widgets.AutoCompleteComboBox;
import dk.eobjects.datacleaner.util.ReflectionHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class OpenDatabaseDialog
extends BanneredDialog {
    private static final int FIELD_COLUMNS = 22;
    private static final long serialVersionUID = 3900489965164055702L;
    private DataContextSelection _dataContextSelection;
    private JComboBox _nameComboBox;
    private AutoCompleteComboBox _driverClassField;
    private JTextField _connectionStringField;
    private JTextField _usernameField;
    private JPasswordField _passwordField;
    private JTextField _catalogField;

    public OpenDatabaseDialog(DataContextSelection dcSelection) {
        this.setModal(true);
        this._dataContextSelection = dcSelection;
        this.setSize(550, 400);
        JTextArea aboutDatabases = new JTextArea();
        aboutDatabases.setEditable(false);
        aboutDatabases.setLineWrap(true);
        aboutDatabases.setWrapStyleWord(true);
        aboutDatabases.setText("The named connections are pre-configured database connections that have been stored for easy reuse. To add or modify the named connections edit the 'datacleaner-config.xml' file in the root of the DataCleaner installation.");
        this.add((Component)aboutDatabases, "South");
    }

    protected Component getContent() {
        JPanel panel = new JPanel();
        GuiHelper.addToGridBag(new JLabel("Please fill out the form below to connect to your database..."), panel, 0, 0, 2, 1);
        GuiHelper.addToGridBag(new JLabel("Named connection:"), panel, 0, 1, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Database driver:"), panel, 0, 2, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Connection string:"), panel, 0, 3, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Username:"), panel, 0, 4, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Password:"), panel, 0, 5, 1, 1);
        GuiHelper.addToGridBag(new JLabel("Catalog:"), panel, 0, 6, 1, 1);
        ArrayList<DatabaseDriver> drivers = new ArrayList<DatabaseDriver>(GuiConfiguration.getBeansOfClass(DatabaseDriver.class));
        drivers.addAll(GuiSettings.getSettings().getDatabaseDrivers());
        Object[] items = ReflectionHelper.getProperties(drivers, (String)"driverClass");
        this._driverClassField = new AutoCompleteComboBox(items);
        this._driverClassField.setName("Database driver");
        GuiHelper.addToGridBag(this._driverClassField, panel, 1, 2, 1, 1);
        this._connectionStringField = new JTextField(22);
        GuiHelper.addToGridBag(this._connectionStringField, panel, 1, 3, 1, 1);
        this._usernameField = new JTextField(22);
        GuiHelper.addToGridBag(this._usernameField, panel, 1, 4, 1, 1);
        this._passwordField = new JPasswordField(22);
        GuiHelper.addToGridBag(this._passwordField, panel, 1, 5, 1, 1);
        this._catalogField = new JTextField(22);
        GuiHelper.addToGridBag(this._catalogField, panel, 1, 6, 1, 1);
        Object[] namedConnections = GuiConfiguration.getBeansOfClass(NamedConnection.class).toArray(new NamedConnection[0]);
        final Object[] connectionNames = ReflectionHelper.getProperties((Object[])namedConnections, (String)"name");
        this._nameComboBox = new JComboBox<Object>(connectionNames);
        this._nameComboBox.setEditable(false);
        this._nameComboBox.setName("Named connection");
        this._nameComboBox.addActionListener(new AbstractAction((NamedConnection[])namedConnections){
            private static final long serialVersionUID = -2655701156220804159L;
            final /* synthetic */ NamedConnection[] val$namedConnections;
            {
                this.val$namedConnections = namedConnectionArray;
            }

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = OpenDatabaseDialog.this._nameComboBox.getSelectedItem();
                for (int i = 0; i < connectionNames.length; ++i) {
                    if (!connectionNames[i].equals(selectedItem)) continue;
                    OpenDatabaseDialog.this.updateForm(this.val$namedConnections[i]);
                    break;
                }
            }
        });
        GuiHelper.addToGridBag(this._nameComboBox, panel, 1, 1, 1, 1);
        JButton connectButton = new JButton();
        connectButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -8103304465976127793L;

            public void actionPerformed(ActionEvent event) {
                String catalog;
                String password = new String(OpenDatabaseDialog.this._passwordField.getPassword());
                String username = OpenDatabaseDialog.this._usernameField.getText();
                if ("".equals(username) && "".equals(password)) {
                    username = null;
                    password = null;
                }
                if ((catalog = OpenDatabaseDialog.this._catalogField.getText()) != null && catalog.length() == 0) {
                    catalog = null;
                }
                try {
                    Connection connection = DriverManager.getConnection(OpenDatabaseDialog.this._connectionStringField.getText(), username, password);
                    connection.setReadOnly(true);
                    if (GuiHelper.selectSchemaByDatabase(OpenDatabaseDialog.this._dataContextSelection, connection, catalog)) {
                        OpenDatabaseDialog.this.setVisible(false);
                    }
                }
                catch (Exception e) {
                    GuiHelper.showErrorMessage("Could not open connection", "An error occurred while trying to open connection to the database.", e);
                }
            }
        });
        connectButton.setText("Connect to database");
        connectButton.setIcon(GuiHelper.getImageIcon("images/toolbar_database.png"));
        GuiHelper.addToGridBag(connectButton, panel, 0, 8, 2, 1);
        if (namedConnections.length > 0) {
            this.updateForm((NamedConnection)namedConnections[0]);
        }
        return panel;
    }

    private void updateForm(NamedConnection namedConnection) {
        if (namedConnection != null) {
            this._driverClassField.setSelectedItem(namedConnection.getDriverClass());
            this._connectionStringField.setText(namedConnection.getConnectionString());
            this._usernameField.setText(namedConnection.getUsername());
            this._passwordField.setText(namedConnection.getPassword());
            this._catalogField.setText(namedConnection.getCatalog());
        }
    }

    protected String getDialogTitle() {
        return "Open database";
    }
}

