/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.gui.DataCleanerGui;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.dialogs.DatabaseDriverDialog;
import dk.eobjects.datacleaner.gui.model.DatabaseDriver;
import dk.eobjects.datacleaner.gui.panels.LookAndFeelSettingsPanel;
import dk.eobjects.datacleaner.gui.setup.GuiConfiguration;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsDialog
extends BanneredDialog
implements Observer {
    private static final ImageIcon ICON_SUCCESS = GuiHelper.getImageIcon("images/driver_success.png");
    private static final ImageIcon ICON_ERROR = GuiHelper.getImageIcon("images/driver_error.png");
    private static final long serialVersionUID = -2821019697454011890L;
    private LookAndFeelSettingsPanel _lafPanel;
    private GuiSettings _settings;
    private JTabbedPane _tabbedPane;
    private JPanel _driversPanel;

    public SettingsDialog() {
        super(450, 500);
    }

    protected Component getContent() {
        JPanel content = new JPanel(new BorderLayout());
        this._settings = GuiSettings.getSettings();
        this._settings.addObserver(this);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.setName("categoriesTab");
        this._tabbedPane.addTab("Look and feel", this.getLookAndFeelTab());
        this._driversPanel = new JPanel(new FlowLayout(0, 10, 10));
        this._driversPanel.setName("driversPanel");
        this._tabbedPane.addTab("Database drivers", new JScrollPane(this._driversPanel));
        this.updateDatabaseDriversTab();
        content.add((Component)this._tabbedPane, "Center");
        JToolBar toolBar = this.getToolbar();
        content.add((Component)toolBar, "South");
        return content;
    }

    private JToolBar getToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setRollover(true);
        toolbar.setFloatable(false);
        JButton saveButton = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 8901279073764413605L;

            public void actionPerformed(ActionEvent event) {
                SettingsDialog.this.saveSettings();
                SettingsDialog.this.dispose();
            }
        });
        saveButton.setIcon(GuiHelper.getImageIcon("images/toolbar_save.png"));
        saveButton.setText("Save settings");
        toolbar.add(saveButton);
        return toolbar;
    }

    private Component getLookAndFeelTab() {
        this._lafPanel = new LookAndFeelSettingsPanel(this._settings);
        JScrollPane scrollPane = new JScrollPane(this._lafPanel);
        return scrollPane;
    }

    private void updateDatabaseDriversTab() {
        this._driversPanel.removeAll();
        Dimension d = new Dimension();
        d.width = 430;
        this._driversPanel.setSize(d);
        this._driversPanel.setPreferredSize(d);
        JLabel header = new JLabel("Database drivers");
        header.setFont(GuiHelper.HEADER_FONT);
        d = new Dimension();
        d.width = 200;
        d.height = 20;
        header.setSize(d);
        header.setPreferredSize(d);
        this._driversPanel.add(header);
        JButton registerDriverButton = new JButton("Register database driver", GuiHelper.getImageIcon("images/toolbar_database.png"));
        registerDriverButton.addActionListener(DatabaseDriverDialog.getActionListener());
        registerDriverButton.setName("registerDriverButton");
        d = new Dimension();
        d.width = 200;
        d.height = 30;
        registerDriverButton.setSize(d);
        registerDriverButton.setPreferredSize(d);
        this._driversPanel.add(registerDriverButton);
        ArrayList<DatabaseDriver> drivers = new ArrayList<DatabaseDriver>(GuiConfiguration.getBeansOfClass(DatabaseDriver.class));
        drivers.addAll(this._settings.getDatabaseDrivers());
        int i = 0;
        for (final DatabaseDriver driver : drivers) {
            final JPanel driverPanel = new JPanel();
            JLabel nameLabel = driver.getName() == null ? new JLabel(driver.getFilename()) : new JLabel(driver.getName());
            if (driver.isLoaded()) {
                nameLabel.setIcon(ICON_SUCCESS);
            } else {
                nameLabel.setIcon(ICON_ERROR);
                nameLabel.setToolTipText("An error occurred while loading the database driver");
            }
            GuiHelper.addToGridBag(nameLabel, driverPanel, 0, 0, 2, 1);
            GuiHelper.addToGridBag(new JLabel(driver.getDriverClass()), driverPanel, 0, 1, 1, 1);
            if (driver.getFilename() != null) {
                driverPanel.setName("driverPanel" + i);
                JButton removeButton = new JButton(GuiHelper.getImageIcon("images/toolbar_remove.png"));
                removeButton.setToolTipText("Remove driver");
                removeButton.setName("removeButton" + i);
                removeButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        driver.unloadDriver();
                        SettingsDialog.this._settings.getDatabaseDrivers().remove(driver);
                        GuiSettings.saveSettings(SettingsDialog.this._settings);
                        SettingsDialog.this._driversPanel.remove(driverPanel);
                        SettingsDialog.this._driversPanel.updateUI();
                    }
                });
                GuiHelper.addToGridBag(removeButton, driverPanel, 1, 1, 1, 1);
                ++i;
            }
            driverPanel.setBackground(HighlighterFactory.BEIGE);
            driverPanel.setBorder(new CompoundBorder(new LineBorder(Color.DARK_GRAY), new EmptyBorder(2, 2, 2, 2)));
            GridBagLayout layout = (GridBagLayout)driverPanel.getLayout();
            layout.columnWidths = new int[]{370, 30};
            this._driversPanel.add(driverPanel);
        }
    }

    private void saveSettings() {
        try {
            String lookAndFeelClassName = this._lafPanel.getLookAndFeelClassName();
            UIManager.setLookAndFeel(lookAndFeelClassName);
            DataCleanerGui.getMainWindow().repaintAll();
            this._settings.setLookAndFeelClassName(lookAndFeelClassName);
        }
        catch (Exception e) {
            GuiHelper.showErrorMessage("Could not apply Look and feel", e.getMessage(), e);
        }
        GuiSettings.saveSettings(this._settings);
    }

    protected String getDialogTitle() {
        return "Settings";
    }

    public void dispose() {
        this._settings.deleteObserver(this);
        super.dispose();
    }

    public void update(Observable o, Object arg) {
        if (o instanceof GuiSettings) {
            this.updateDatabaseDriversTab();
        }
    }
}

