/*
 * Decompiled with CFR 0.152.
 */
package dk.eobjects.datacleaner.gui.dialogs;

import dk.eobjects.datacleaner.catalog.IDictionary;
import dk.eobjects.datacleaner.catalog.TextFileDictionary;
import dk.eobjects.datacleaner.gui.GuiHelper;
import dk.eobjects.datacleaner.gui.dialogs.BanneredDialog;
import dk.eobjects.datacleaner.gui.setup.GuiSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TextFileDictionaryDialog
extends BanneredDialog {
    private static final long serialVersionUID = -4903413130380918278L;
    private static final Dimension BUTTON_DIMENSION = new Dimension(84, 18);
    private TextFileDictionary _dictionary;
    private JTextField _nameField;
    private JTextField _filenameField;

    public TextFileDictionaryDialog(TextFileDictionary dictionary) {
        super(400, 320);
        JTextArea aboutTextFileDictionaries = new JTextArea();
        aboutTextFileDictionaries.setEditable(false);
        aboutTextFileDictionaries.setLineWrap(true);
        aboutTextFileDictionaries.setWrapStyleWord(true);
        aboutTextFileDictionaries.setText("Text-file dictionaries are dictionaries based on flat files. Register a flat file here and all the words (seperated by whitespace or line-breaks) within the file will be used to populate the dictionary.");
        this.add((Component)aboutTextFileDictionaries, "South");
        this._dictionary = dictionary;
        this.updateDialog();
    }

    private void updateDialog() {
        if (this._dictionary != null) {
            this._nameField.setText(this._dictionary.getName());
            this._filenameField.setText(this._dictionary.getDictionaryFile().getAbsolutePath());
        }
    }

    protected Component getContent() {
        final JPanel panel = new JPanel();
        JLabel header = new JLabel("Text-file dictionary");
        header.setFont(GuiHelper.HEADER_FONT);
        GuiHelper.addToGridBag(header, panel, 0, 0, 3, 1);
        GuiHelper.addToGridBag(new JLabel("Dictionary name:"), panel, 0, 1);
        this._nameField = new JTextField();
        GuiHelper.addToGridBag(this._nameField, panel, 1, 1, 2, 1);
        this._nameField.setPreferredSize(new Dimension(200, 20));
        GuiHelper.addToGridBag(new JLabel("Filename:"), panel, 0, 2);
        this._filenameField = new JTextField();
        GuiHelper.addToGridBag(this._filenameField, panel, 1, 2, 1, 1);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                GuiHelper.centerOnScreen(fileChooser);
                if (fileChooser.showOpenDialog(panel) == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    TextFileDictionaryDialog.this._filenameField.setText(selectedFile.getAbsolutePath());
                }
            }
        });
        browseButton.setPreferredSize(BUTTON_DIMENSION);
        GuiHelper.addToGridBag(browseButton, panel, 2, 2);
        JButton saveButton = new JButton("Save dictionary", GuiHelper.getImageIcon("images/dictionaries.png"));
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String name = TextFileDictionaryDialog.this._nameField.getText();
                String filename = TextFileDictionaryDialog.this._filenameField.getText();
                GuiSettings settings = GuiSettings.getSettings();
                File file = new File(filename);
                if (file.exists() && file.isFile()) {
                    if ((name = name.trim()).length() > 2) {
                        if (TextFileDictionaryDialog.this._dictionary == null) {
                            TextFileDictionaryDialog.this._dictionary = new TextFileDictionary(name, file);
                            settings.getDictionaries().add((IDictionary)TextFileDictionaryDialog.this._dictionary);
                        } else {
                            TextFileDictionaryDialog.this._dictionary.setName(name);
                            TextFileDictionaryDialog.this._dictionary.setDictionaryFile(file);
                        }
                        GuiSettings.saveSettings(settings);
                        TextFileDictionaryDialog.this.dispose();
                    } else {
                        GuiHelper.showErrorMessage("Dictionary name required", "Please provide a name of minimum 3 characters for your dictionary.", new IllegalArgumentException(name));
                    }
                } else {
                    GuiHelper.showErrorMessage("File not found", "The file [" + filename + "] does not exist or is not a valid file. Please select an existing file for your new text-file dictionary.", new IllegalArgumentException(filename));
                }
            }
        });
        GuiHelper.addToGridBag(saveButton, panel, 1, 3, 2, 1);
        GridBagLayout layout = (GridBagLayout)panel.getLayout();
        layout.columnWidths = new int[]{70, 220, 70};
        return panel;
    }

    protected String getDialogTitle() {
        return "Text-file dictionary";
    }
}

